/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import org.apache.seatunnel.engine.core.job.ConnectorJar;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.service.jar.ServerConnectorPackageClient;

public class SendConnectorJarToMemberNodeOperation
extends Operation
implements IdentifiedDataSerializable {
    private ConnectorJar connectorJar;
    private ConnectorJarIdentifier connectorJarIdentifier;

    public SendConnectorJarToMemberNodeOperation() {
    }

    public SendConnectorJarToMemberNodeOperation(ConnectorJar connectorJar, ConnectorJarIdentifier connectorJarIdentifier) {
        this.connectorJar = connectorJar;
        this.connectorJarIdentifier = connectorJarIdentifier;
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 23;
    }

    public void run() throws Exception {
        SeaTunnelServer seaTunnelServer = (SeaTunnelServer)this.getService();
        ServerConnectorPackageClient serverConnectorPackageClient = seaTunnelServer.getTaskExecutionService().getServerConnectorPackageClient();
        serverConnectorPackageClient.storageConnectorJarFile(this.connectorJar.getData(), this.connectorJarIdentifier);
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject((Object)this.connectorJar);
        out.writeObject((Object)this.connectorJarIdentifier);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.connectorJar = (ConnectorJar)in.readObject();
        this.connectorJarIdentifier = (ConnectorJarIdentifier)in.readObject();
    }
}

