/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TracingOperation;

public class CheckTaskGroupIsExecutingOperation
extends TracingOperation
implements IdentifiedDataSerializable {
    private TaskGroupLocation taskGroupLocation;
    private Boolean response;

    public CheckTaskGroupIsExecutingOperation() {
    }

    public CheckTaskGroupIsExecutingOperation(TaskGroupLocation taskGroupLocation) {
        this.taskGroupLocation = taskGroupLocation;
    }

    @Override
    public void runInternal() {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        try {
            this.response = server.getTaskExecutionService().getActiveExecutionContext(this.taskGroupLocation) != null;
        }
        catch (TaskGroupContextNotFoundException e) {
            this.response = false;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject((Object)this.taskGroupLocation);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.taskGroupLocation = (TaskGroupLocation)in.readObject();
    }

    public String getServiceName() {
        return "st:impl:seaTunnelServer";
    }

    public Object getResponse() {
        return this.response;
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 21;
    }
}

