/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.execution.TaskGroupType;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;

public class TaskGroupImmutableInformation
implements IdentifiedDataSerializable {
    private long jobId;
    private long executionId;
    private TaskGroupType taskGroupType;
    private TaskGroupLocation taskGroupLocation;
    private String taskGroupName;
    private List<Data> tasksData;
    private List<Set<URL>> jars;
    private List<Set<ConnectorJarIdentifier>> connectorJarIdentifiers;

    public TaskGroupImmutableInformation() {
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 4;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeLong(this.executionId);
        out.writeObject((Object)this.taskGroupType);
        out.writeObject(this.jars);
        out.writeObject(this.connectorJarIdentifiers);
        out.writeInt(this.tasksData.size());
        for (Data data : this.tasksData) {
            IOUtil.writeData((ObjectDataOutput)out, (Data)data);
        }
        out.writeObject((Object)this.taskGroupLocation);
        out.writeString(this.taskGroupName);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.executionId = in.readLong();
        this.taskGroupType = (TaskGroupType)((Object)in.readObject());
        this.jars = (List)in.readObject();
        this.connectorJarIdentifiers = (List)in.readObject();
        int size = in.readInt();
        this.tasksData = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            this.tasksData.add(IOUtil.readData((ObjectDataInput)in));
        }
        this.taskGroupLocation = (TaskGroupLocation)in.readObject();
        this.taskGroupName = in.readString();
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public TaskGroupType getTaskGroupType() {
        return this.taskGroupType;
    }

    public TaskGroupLocation getTaskGroupLocation() {
        return this.taskGroupLocation;
    }

    public String getTaskGroupName() {
        return this.taskGroupName;
    }

    public List<Data> getTasksData() {
        return this.tasksData;
    }

    public List<Set<URL>> getJars() {
        return this.jars;
    }

    public List<Set<ConnectorJarIdentifier>> getConnectorJarIdentifiers() {
        return this.connectorJarIdentifiers;
    }

    public void setJobId(long jobId) {
        this.jobId = jobId;
    }

    public void setExecutionId(long executionId) {
        this.executionId = executionId;
    }

    public void setTaskGroupType(TaskGroupType taskGroupType) {
        this.taskGroupType = taskGroupType;
    }

    public void setTaskGroupLocation(TaskGroupLocation taskGroupLocation) {
        this.taskGroupLocation = taskGroupLocation;
    }

    public void setTaskGroupName(String taskGroupName) {
        this.taskGroupName = taskGroupName;
    }

    public void setTasksData(List<Data> tasksData) {
        this.tasksData = tasksData;
    }

    public void setJars(List<Set<URL>> jars) {
        this.jars = jars;
    }

    public void setConnectorJarIdentifiers(List<Set<ConnectorJarIdentifier>> connectorJarIdentifiers) {
        this.connectorJarIdentifiers = connectorJarIdentifiers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskGroupImmutableInformation)) {
            return false;
        }
        TaskGroupImmutableInformation other = (TaskGroupImmutableInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getJobId() != other.getJobId()) {
            return false;
        }
        if (this.getExecutionId() != other.getExecutionId()) {
            return false;
        }
        TaskGroupType this$taskGroupType = this.getTaskGroupType();
        TaskGroupType other$taskGroupType = other.getTaskGroupType();
        if (this$taskGroupType == null ? other$taskGroupType != null : !((Object)((Object)this$taskGroupType)).equals((Object)other$taskGroupType)) {
            return false;
        }
        TaskGroupLocation this$taskGroupLocation = this.getTaskGroupLocation();
        TaskGroupLocation other$taskGroupLocation = other.getTaskGroupLocation();
        if (this$taskGroupLocation == null ? other$taskGroupLocation != null : !((Object)this$taskGroupLocation).equals(other$taskGroupLocation)) {
            return false;
        }
        String this$taskGroupName = this.getTaskGroupName();
        String other$taskGroupName = other.getTaskGroupName();
        if (this$taskGroupName == null ? other$taskGroupName != null : !this$taskGroupName.equals(other$taskGroupName)) {
            return false;
        }
        List<Data> this$tasksData = this.getTasksData();
        List<Data> other$tasksData = other.getTasksData();
        if (this$tasksData == null ? other$tasksData != null : !((Object)this$tasksData).equals(other$tasksData)) {
            return false;
        }
        List<Set<URL>> this$jars = this.getJars();
        List<Set<URL>> other$jars = other.getJars();
        if (this$jars == null ? other$jars != null : !((Object)this$jars).equals(other$jars)) {
            return false;
        }
        List<Set<ConnectorJarIdentifier>> this$connectorJarIdentifiers = this.getConnectorJarIdentifiers();
        List<Set<ConnectorJarIdentifier>> other$connectorJarIdentifiers = other.getConnectorJarIdentifiers();
        return !(this$connectorJarIdentifiers == null ? other$connectorJarIdentifiers != null : !((Object)this$connectorJarIdentifiers).equals(other$connectorJarIdentifiers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskGroupImmutableInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $jobId = this.getJobId();
        result = result * 59 + (int)($jobId >>> 32 ^ $jobId);
        long $executionId = this.getExecutionId();
        result = result * 59 + (int)($executionId >>> 32 ^ $executionId);
        TaskGroupType $taskGroupType = this.getTaskGroupType();
        result = result * 59 + ($taskGroupType == null ? 43 : ((Object)((Object)$taskGroupType)).hashCode());
        TaskGroupLocation $taskGroupLocation = this.getTaskGroupLocation();
        result = result * 59 + ($taskGroupLocation == null ? 43 : ((Object)$taskGroupLocation).hashCode());
        String $taskGroupName = this.getTaskGroupName();
        result = result * 59 + ($taskGroupName == null ? 43 : $taskGroupName.hashCode());
        List<Data> $tasksData = this.getTasksData();
        result = result * 59 + ($tasksData == null ? 43 : ((Object)$tasksData).hashCode());
        List<Set<URL>> $jars = this.getJars();
        result = result * 59 + ($jars == null ? 43 : ((Object)$jars).hashCode());
        List<Set<ConnectorJarIdentifier>> $connectorJarIdentifiers = this.getConnectorJarIdentifiers();
        result = result * 59 + ($connectorJarIdentifiers == null ? 43 : ((Object)$connectorJarIdentifiers).hashCode());
        return result;
    }

    public String toString() {
        return "TaskGroupImmutableInformation(jobId=" + this.getJobId() + ", executionId=" + this.getExecutionId() + ", taskGroupType=" + (Object)((Object)this.getTaskGroupType()) + ", taskGroupLocation=" + this.getTaskGroupLocation() + ", taskGroupName=" + this.getTaskGroupName() + ", tasksData=" + this.getTasksData() + ", jars=" + this.getJars() + ", connectorJarIdentifiers=" + this.getConnectorJarIdentifiers() + ")";
    }

    public TaskGroupImmutableInformation(long jobId, long executionId, TaskGroupType taskGroupType, TaskGroupLocation taskGroupLocation, String taskGroupName, List<Data> tasksData, List<Set<URL>> jars, List<Set<ConnectorJarIdentifier>> connectorJarIdentifiers) {
        this.jobId = jobId;
        this.executionId = executionId;
        this.taskGroupType = taskGroupType;
        this.taskGroupLocation = taskGroupLocation;
        this.taskGroupName = taskGroupName;
        this.tasksData = tasksData;
        this.jars = jars;
        this.connectorJarIdentifiers = connectorJarIdentifiers;
    }
}

