/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.event.handler.DataTypeChangeEventDispatcher;
import org.apache.seatunnel.api.table.event.handler.DataTypeChangeEventHandler;
import org.apache.seatunnel.api.table.type.MultipleRowType;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.core.starter.flowcontrol.FlowControlGate;
import org.apache.seatunnel.core.starter.flowcontrol.FlowControlStrategy;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.server.metrics.TaskMetricsCalcContext;
import org.apache.seatunnel.engine.server.task.flow.OneInputFlowLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnelSourceCollector<T>
implements Collector<T> {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelSourceCollector.class);
    private final Object checkpointLock;
    private final List<OneInputFlowLifeCycle<Record<?>>> outputs;
    private final MetricsContext metricsContext;
    private final TaskMetricsCalcContext taskMetricsCalcContext;
    private final AtomicBoolean schemaChangeBeforeCheckpointSignal = new AtomicBoolean(false);
    private final AtomicBoolean schemaChangeAfterCheckpointSignal = new AtomicBoolean(false);
    private volatile boolean emptyThisPollNext;
    private final DataTypeChangeEventHandler dataTypeChangeEventHandler = new DataTypeChangeEventDispatcher();
    private Map<String, SeaTunnelRowType> rowTypeMap = new HashMap<String, SeaTunnelRowType>();
    private SeaTunnelDataType rowType;
    private FlowControlGate flowControlGate;

    public SeaTunnelSourceCollector(Object checkpointLock, List<OneInputFlowLifeCycle<Record<?>>> outputs, MetricsContext metricsContext, FlowControlStrategy flowControlStrategy, SeaTunnelDataType rowType, List<TablePath> tablePaths) {
        this.checkpointLock = checkpointLock;
        this.outputs = outputs;
        this.rowType = rowType;
        this.metricsContext = metricsContext;
        if (rowType instanceof MultipleRowType) {
            ((MultipleRowType)rowType).iterator().forEachRemaining(type -> this.rowTypeMap.put((String)type.getKey(), (SeaTunnelRowType)type.getValue()));
        }
        this.taskMetricsCalcContext = new TaskMetricsCalcContext(metricsContext, PluginType.SOURCE, CollectionUtils.isNotEmpty(tablePaths), tablePaths);
        this.flowControlGate = FlowControlGate.create((FlowControlStrategy)flowControlStrategy);
    }

    public void collect(T row) {
        try {
            if (row instanceof SeaTunnelRow) {
                String tableId = ((SeaTunnelRow)row).getTableId();
                if (this.rowType instanceof SeaTunnelRowType) {
                    int size = ((SeaTunnelRow)row).getBytesSize((SeaTunnelRowType)this.rowType);
                } else if (this.rowType instanceof MultipleRowType) {
                    int size = ((SeaTunnelRow)row).getBytesSize(this.rowTypeMap.get(tableId));
                } else {
                    throw new SeaTunnelEngineException("Unsupported row type: " + this.rowType.getClass().getName());
                }
                this.flowControlGate.audit((SeaTunnelRow)row);
                this.taskMetricsCalcContext.updateMetrics(row);
            }
            this.sendRecordToNext(new Record(row));
            this.emptyThisPollNext = false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void collect(SchemaChangeEvent event) {
        try {
            if (this.rowType instanceof SeaTunnelRowType) {
                this.rowType = this.dataTypeChangeEventHandler.reset((SeaTunnelRowType)this.rowType).apply(event);
            } else if (this.rowType instanceof MultipleRowType) {
                String tableId = event.tablePath().toString();
                this.rowTypeMap.put(tableId, this.dataTypeChangeEventHandler.reset(this.rowTypeMap.get(tableId)).apply(event));
            } else {
                throw new SeaTunnelEngineException("Unsupported row type: " + this.rowType.getClass().getName());
            }
            this.sendRecordToNext(new Record((Object)event));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void markSchemaChangeBeforeCheckpoint() {
        if (this.schemaChangeAfterCheckpointSignal.get()) {
            throw new IllegalStateException("schema-change-after checkpoint already marked.");
        }
        if (!this.schemaChangeBeforeCheckpointSignal.compareAndSet(false, true)) {
            throw new IllegalStateException("schema-change-before checkpoint already marked.");
        }
        log.info("mark schema-change-before checkpoint signal.");
    }

    public void markSchemaChangeAfterCheckpoint() {
        if (this.schemaChangeBeforeCheckpointSignal.get()) {
            throw new IllegalStateException("schema-change-before checkpoint already marked.");
        }
        if (!this.schemaChangeAfterCheckpointSignal.compareAndSet(false, true)) {
            throw new IllegalStateException("schema-change-after checkpoint already marked.");
        }
        log.info("mark schema-change-after checkpoint signal.");
    }

    public boolean captureSchemaChangeBeforeCheckpointSignal() {
        if (this.schemaChangeBeforeCheckpointSignal.get()) {
            log.info("capture schema-change-before checkpoint signal.");
            return this.schemaChangeBeforeCheckpointSignal.getAndSet(false);
        }
        return false;
    }

    public boolean captureSchemaChangeAfterCheckpointSignal() {
        if (this.schemaChangeAfterCheckpointSignal.get()) {
            log.info("capture schema-change-after checkpoint signal.");
            return this.schemaChangeAfterCheckpointSignal.getAndSet(false);
        }
        return false;
    }

    public Object getCheckpointLock() {
        return this.checkpointLock;
    }

    public boolean isEmptyThisPollNext() {
        return this.emptyThisPollNext;
    }

    public void resetEmptyThisPollNext() {
        this.emptyThisPollNext = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRecordToNext(Record<?> record) throws IOException {
        Object object = this.checkpointLock;
        synchronized (object) {
            for (OneInputFlowLifeCycle<Record<?>> output : this.outputs) {
                output.received(record);
            }
        }
    }
}

