/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.service.jar;

import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.engine.common.config.SeaTunnelProperties;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageConfig;
import org.apache.seatunnel.engine.core.job.ConnectorJar;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.service.jar.ConnectorJarStorageStrategy;
import org.apache.seatunnel.engine.server.task.operation.DeleteConnectorJarInExecutionNode;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public abstract class AbstractConnectorJarStorageStrategy
implements ConnectorJarStorageStrategy {
    protected static final ILogger LOGGER = Logger.getLogger(AbstractConnectorJarStorageStrategy.class);
    protected static final String COMMON_PLUGIN_JAR_STORAGE_PATH = "/plugins";
    protected static final String CONNECTOR_PLUGIN_JAR_STORAGE_PATH = "/connectors";
    protected String storageDir;
    protected final ConnectorJarStorageConfig connectorJarStorageConfig;
    protected final SeaTunnelServer seaTunnelServer;
    protected final NodeEngineImpl nodeEngine;

    public AbstractConnectorJarStorageStrategy(ConnectorJarStorageConfig connectorJarStorageConfig, SeaTunnelServer seaTunnelServer) {
        this.seaTunnelServer = seaTunnelServer;
        this.nodeEngine = seaTunnelServer.getNodeEngine();
        Preconditions.checkNotNull((Object)connectorJarStorageConfig);
        this.connectorJarStorageConfig = connectorJarStorageConfig;
        this.storageDir = this.getConnectorJarStorageDir();
    }

    @Override
    public File getStorageLocation(long jobId, ConnectorJar connectorJar) {
        Preconditions.checkNotNull((Object)jobId);
        File file = new File(this.getStorageLocationPath(jobId, connectorJar));
        try {
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warning(String.format("The creation of directories : %s for the connector jar storage path has failed.", file.getParentFile().toPath()));
        }
        return file;
    }

    @Override
    public ConnectorJarIdentifier getConnectorJarIdentifier(long jobId, ConnectorJar connectorJar) {
        return ConnectorJarIdentifier.of((ConnectorJar)connectorJar, (String)this.getStorageLocationPath(jobId, connectorJar));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Path> storageConnectorJarFileInternal(ConnectorJar connectorJar, File storageFile) {
        boolean success = false;
        try {
            if (!storageFile.exists()) {
                Files.write(storageFile.toPath(), connectorJar.getData(), new OpenOption[0]);
            } else {
                LOGGER.warning(String.format("File storage for an existing file %s. This may indicate a duplicate upload. Ignoring newest upload.", storageFile));
            }
            success = true;
            if (success || storageFile.delete() || !storageFile.exists()) return success ? Optional.of(storageFile.toPath()) : Optional.empty();
        }
        catch (IOException ioe) {
            try {
                LOGGER.warning(String.format("The connector jar package file %s storage failed.", storageFile));
                if (success || storageFile.delete() || !storageFile.exists()) return success ? Optional.of(storageFile.toPath()) : Optional.empty();
            }
            catch (Throwable throwable) {
                if (success || storageFile.delete() || !storageFile.exists()) throw throwable;
                LOGGER.warning(String.format("Could not delete the corrupted connector jar package file %s.", storageFile));
                throw throwable;
            }
            LOGGER.warning(String.format("Could not delete the corrupted connector jar package file %s.", storageFile));
            return success ? Optional.of(storageFile.toPath()) : Optional.empty();
        }
        LOGGER.warning(String.format("Could not delete the corrupted connector jar package file %s.", storageFile));
        return success ? Optional.of(storageFile.toPath()) : Optional.empty();
    }

    private String getConnectorJarStorageDir() {
        String userDefinedStoragePath = this.connectorJarStorageConfig.getStoragePath();
        if (StringUtils.isNotBlank((CharSequence)userDefinedStoragePath)) {
            return new File(userDefinedStoragePath).getAbsolutePath();
        }
        return new File(System.getProperty(SeaTunnelProperties.SEATUNNEL_HOME.getName(), SeaTunnelProperties.SEATUNNEL_HOME.getDefaultValue())).getAbsolutePath();
    }

    @Override
    public void deleteConnectorJarInternal(File storageFile) {
        if (!storageFile.delete() && storageFile.exists()) {
            LOGGER.warning(String.format("Failed to delete connector jar file %s", storageFile));
        }
    }

    @Override
    public void deleteConnectorJarInExecutionNode(ConnectorJarIdentifier connectorJarIdentifier) {
        Address masterNodeAddress = this.nodeEngine.getMasterAddress();
        Set memberList = this.nodeEngine.getClusterService().getMembers();
        memberList.forEach(member -> {
            if (!member.getAddress().equals((Object)masterNodeAddress)) {
                NodeEngineUtil.sendOperationToMemberNode((NodeEngine)this.nodeEngine, new DeleteConnectorJarInExecutionNode(connectorJarIdentifier), member.getAddress());
            }
        });
    }
}

