/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.internal.ascii.TextCommand;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpGetCommand;
import com.hazelcast.internal.ascii.rest.HttpStatusCode;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.seatunnel.api.common.metrics.JobMetrics;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.engine.common.env.EnvironmentUtil;
import org.apache.seatunnel.engine.common.env.Version;
import org.apache.seatunnel.engine.core.classloader.ClassLoaderService;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobInfo;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.server.NodeExtension;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.log.Log4j2HttpGetCommandProcessor;
import org.apache.seatunnel.engine.server.master.JobHistoryService;
import org.apache.seatunnel.engine.server.operation.GetClusterHealthMetricsOperation;
import org.apache.seatunnel.engine.server.operation.GetJobMetricsOperation;
import org.apache.seatunnel.engine.server.operation.GetJobStatusOperation;
import org.apache.seatunnel.engine.server.resourcemanager.opeartion.GetOverviewOperation;
import org.apache.seatunnel.engine.server.resourcemanager.resource.OverviewInfo;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class RestHttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    private static final String TABLE_SOURCE_RECEIVED_COUNT = "TableSourceReceivedCount";
    private static final String TABLE_SINK_WRITE_COUNT = "TableSinkWriteCount";
    private static final String TABLE_SOURCE_RECEIVED_QPS = "TableSourceReceivedQPS";
    private static final String TABLE_SINK_WRITE_QPS = "TableSinkWriteQPS";
    private static final String TABLE_SOURCE_RECEIVED_BYTES = "TableSourceReceivedBytes";
    private static final String TABLE_SINK_WRITE_BYTES = "TableSinkWriteBytes";
    private static final String TABLE_SOURCE_RECEIVED_BYTES_PER_SECONDS = "TableSourceReceivedBytesPerSeconds";
    private static final String TABLE_SINK_WRITE_BYTES_PER_SECONDS = "TableSinkWriteBytesPerSeconds";
    private final Log4j2HttpGetCommandProcessor original;
    private NodeEngine nodeEngine;

    public RestHttpGetCommandProcessor(TextCommandService textCommandService) {
        this(textCommandService, new Log4j2HttpGetCommandProcessor(textCommandService));
    }

    public RestHttpGetCommandProcessor(TextCommandService textCommandService, Log4j2HttpGetCommandProcessor log4j2HttpGetCommandProcessor) {
        super(textCommandService, textCommandService.getNode().getLogger(Log4j2HttpGetCommandProcessor.class));
        this.original = log4j2HttpGetCommandProcessor;
    }

    public void handle(HttpGetCommand httpGetCommand) {
        String uri = httpGetCommand.getURI();
        try {
            if (uri.startsWith("/hazelcast/rest/maps/running-jobs")) {
                this.handleRunningJobsInfo(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/finished-jobs")) {
                this.handleFinishedJobsInfo(httpGetCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/running-job") || uri.startsWith("/hazelcast/rest/maps/job-info")) {
                this.handleJobInfoById(httpGetCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/system-monitoring-information")) {
                this.getSystemMonitoringInformation(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/running-threads")) {
                this.getRunningThread(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/overview")) {
                this.overView(httpGetCommand, uri);
            } else if (uri.equals("/hazelcast/rest/instance/metrics")) {
                this.handleMetrics(httpGetCommand, "text/plain; version=0.0.4; charset=utf-8");
            } else if (uri.equals("/hazelcast/rest/instance/openmetrics")) {
                this.handleMetrics(httpGetCommand, "application/openmetrics-text; version=1.0.0; charset=utf-8");
            } else if (uri.startsWith("/hazelcast/rest/maps/thread-dump")) {
                this.getThreadDump(httpGetCommand);
            } else {
                this.original.handle(httpGetCommand);
            }
        }
        catch (IndexOutOfBoundsException e) {
            httpGetCommand.send400();
        }
        catch (Throwable e) {
            this.logger.warning("An error occurred while handling request " + httpGetCommand, e);
            this.prepareResponse(HttpStatusCode.SC_500, (HttpCommand)httpGetCommand, RestHttpGetCommandProcessor.exceptionResponse((Throwable)e));
        }
        this.textCommandService.sendResponse((TextCommand)httpGetCommand);
    }

    public void handleRejection(HttpGetCommand httpGetCommand) {
        this.handle(httpGetCommand);
    }

    public void overView(HttpGetCommand command, String uri) {
        OverviewInfo overviewInfo;
        String tagStr;
        if ((uri = StringUtil.stripTrailingSlash((String)uri)).contains("?")) {
            int index = uri.indexOf("?");
            tagStr = uri.substring(index + 1);
        } else {
            tagStr = "";
        }
        Map<String, String> tags = Arrays.stream(tagStr.split("&")).map(variable -> variable.split("=", 2)).filter(pair -> ((String[])pair).length == 2).collect(Collectors.toMap(pair -> pair[0], pair -> pair[1]));
        Version version = EnvironmentUtil.getVersion();
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(true);
        if (seaTunnelServer == null) {
            overviewInfo = (OverviewInfo)NodeEngineUtil.sendOperationToMasterNode((NodeEngine)this.getNode().nodeEngine, new GetOverviewOperation(tags)).join();
            overviewInfo.setProjectVersion(version.getProjectVersion());
            overviewInfo.setGitCommitAbbrev(version.getGitCommitAbbrev());
        } else {
            NodeEngineImpl nodeEngine = this.textCommandService.getNode().getNodeEngine();
            overviewInfo = GetOverviewOperation.getOverviewInfo(seaTunnelServer, (NodeEngine)nodeEngine, tags);
            overviewInfo.setProjectVersion(version.getProjectVersion());
            overviewInfo.setGitCommitAbbrev(version.getGitCommitAbbrev());
        }
        this.prepareResponse((HttpCommand)command, JsonUtil.toJsonObject((Map)JsonUtils.toMap((String)JsonUtils.toJsonString((Object)overviewInfo))));
    }

    public void getThreadDump(HttpGetCommand command) {
        Map<Thread, StackTraceElement[]> threadStacks = Thread.getAllStackTraces();
        JsonArray threadInfoList = new JsonArray();
        for (Map.Entry<Thread, StackTraceElement[]> entry : threadStacks.entrySet()) {
            StringBuilder stackTraceBuilder = new StringBuilder();
            for (StackTraceElement element : entry.getValue()) {
                stackTraceBuilder.append(element.toString()).append("\n");
            }
            String stackTrace = stackTraceBuilder.toString().trim();
            JsonObject threadInfo = new JsonObject();
            threadInfo.add("threadName", entry.getKey().getName());
            threadInfo.add("threadId", entry.getKey().getId());
            threadInfo.add("threadState", entry.getKey().getState().name());
            threadInfo.add("stackTrace", stackTrace);
            threadInfoList.add((JsonValue)threadInfo);
        }
        this.prepareResponse((HttpCommand)command, threadInfoList);
    }

    private void getSystemMonitoringInformation(HttpGetCommand command) {
        Cluster cluster = this.textCommandService.getNode().hazelcastInstance.getCluster();
        this.nodeEngine = this.textCommandService.getNode().hazelcastInstance.node.nodeEngine;
        Set members = cluster.getMembers();
        JsonArray jsonValues = members.stream().map(member -> {
            Address address = member.getAddress();
            String input = null;
            try {
                input = (String)NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, new GetClusterHealthMetricsOperation(), address).get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("get system monitoring information fail", (Throwable)e);
            }
            String[] parts = input.split(", ");
            JsonObject jobInfo = new JsonObject();
            Arrays.stream(parts).forEach(part -> {
                String[] keyValue = part.split("=");
                jobInfo.add(keyValue[0], keyValue[1]);
            });
            return jobInfo;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse((HttpCommand)command, jsonValues);
    }

    private void handleRunningJobsInfo(HttpGetCommand command) {
        IMap values = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_runningJobInfo");
        JsonArray jobs = values.entrySet().stream().map(jobInfoEntry -> this.convertToJson((JobInfo)jobInfoEntry.getValue(), (Long)jobInfoEntry.getKey())).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse((HttpCommand)command, jobs);
    }

    private void handleFinishedJobsInfo(HttpGetCommand command, String uri) {
        int indexEnd = (uri = StringUtil.stripTrailingSlash((String)uri)).indexOf(47, "/hazelcast/rest/maps/".length());
        String state = indexEnd == -1 ? "" : uri.substring(indexEnd + 1);
        IMap finishedJob = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobState");
        IMap finishedJobMetrics = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobMetrics");
        IMap finishedJobDAGInfo = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobVertexInfo");
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(true);
        JsonArray jobs = finishedJob.values().stream().filter(jobState -> {
            if (state.isEmpty()) {
                return true;
            }
            return jobState.getJobStatus().name().equals(state.toUpperCase());
        }).sorted(Comparator.comparing(JobHistoryService.JobState::getFinishTime)).map(jobState -> {
            Long jobId = jobState.getJobId();
            String jobMetrics = seaTunnelServer == null ? (String)NodeEngineUtil.sendOperationToMasterNode((NodeEngine)this.getNode().nodeEngine, new GetJobMetricsOperation(jobId)).join() : seaTunnelServer.getCoordinatorService().getJobMetrics(jobId).toJsonString();
            return this.getJobInfoJson((JobHistoryService.JobState)jobState, jobMetrics, (JobDAGInfo)finishedJobDAGInfo.get((Object)jobId));
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse((HttpCommand)command, jobs);
    }

    private void handleJobInfoById(HttpGetCommand command, String uri) {
        uri = StringUtil.stripTrailingSlash((String)uri);
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
        String jobId = uri.substring(indexEnd + 1);
        IMap jobInfoMap = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_runningJobInfo");
        JobInfo jobInfo = (JobInfo)jobInfoMap.get((Object)Long.valueOf(jobId));
        IMap finishedJobStateMap = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobState");
        JobHistoryService.JobState finishedJobState = (JobHistoryService.JobState)finishedJobStateMap.get((Object)Long.valueOf(jobId));
        if (!jobId.isEmpty() && jobInfo != null) {
            this.prepareResponse((HttpCommand)command, this.convertToJson(jobInfo, Long.parseLong(jobId)));
        } else if (!jobId.isEmpty() && finishedJobState != null) {
            JobMetrics finishedJobMetrics = (JobMetrics)this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobMetrics").get((Object)Long.valueOf(jobId));
            JobDAGInfo finishedJobDAGInfo = (JobDAGInfo)this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobVertexInfo").get((Object)Long.valueOf(jobId));
            this.prepareResponse((HttpCommand)command, this.getJobInfoJson(finishedJobState, finishedJobMetrics.toJsonString(), finishedJobDAGInfo));
        } else {
            this.prepareResponse((HttpCommand)command, new JsonObject().add("jobId", jobId));
        }
    }

    private void getRunningThread(HttpGetCommand command) {
        this.prepareResponse((HttpCommand)command, Thread.getAllStackTraces().keySet().stream().sorted(Comparator.comparing(Thread::getName)).map(stackTraceElements -> {
            JsonObject jobInfoJson = new JsonObject();
            jobInfoJson.add("threadName", stackTraceElements.getName());
            jobInfoJson.add("classLoader", String.valueOf(stackTraceElements.getContextClassLoader()));
            return jobInfoJson;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add));
    }

    private Map<String, Object> getJobMetrics(String jobMetrics) {
        HashMap<String, Object> metricsMap = new HashMap<String, Object>();
        Object[] countMetricsNames = new String[]{"SourceReceivedCount", "SinkWriteCount", "SourceReceivedBytes", "SinkWriteBytes"};
        Object[] rateMetricsNames = new String[]{"SourceReceivedQPS", "SinkWriteQPS", "SourceReceivedBytesPerSeconds", "SinkWriteBytesPerSeconds"};
        Object[] tableCountMetricsNames = new String[]{TABLE_SOURCE_RECEIVED_COUNT, TABLE_SINK_WRITE_COUNT, TABLE_SOURCE_RECEIVED_BYTES, TABLE_SINK_WRITE_BYTES};
        Object[] tableRateMetricsNames = new String[]{TABLE_SOURCE_RECEIVED_QPS, TABLE_SINK_WRITE_QPS, TABLE_SOURCE_RECEIVED_BYTES_PER_SECONDS, TABLE_SINK_WRITE_BYTES_PER_SECONDS};
        Long[] metricsSums = (Long[])Stream.generate(() -> 0L).limit(countMetricsNames.length).toArray(Long[]::new);
        Double[] metricsRates = (Double[])Stream.generate(() -> 0.0).limit(rateMetricsNames.length).toArray(Double[]::new);
        Object[] tableMetricsMaps = new Map[]{new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap()};
        try {
            JsonNode jobMetricsStr = new ObjectMapper().readTree(jobMetrics);
            jobMetricsStr.fieldNames().forEachRemaining(arg_0 -> this.lambda$getJobMetrics$14(jobMetricsStr, (Map[])tableMetricsMaps, arg_0));
            this.aggregateMetrics(jobMetricsStr, metricsSums, metricsRates, (String[])ArrayUtils.addAll((Object[])countMetricsNames, (Object[])rateMetricsNames));
        }
        catch (JsonProcessingException e) {
            return metricsMap;
        }
        this.populateMetricsMap(metricsMap, tableMetricsMaps, (String[])ArrayUtils.addAll((Object[])tableCountMetricsNames, (Object[])tableRateMetricsNames), countMetricsNames.length);
        this.populateMetricsMap(metricsMap, Stream.concat(Arrays.stream(metricsSums), Arrays.stream(metricsRates)).toArray(Number[]::new), (String[])ArrayUtils.addAll((Object[])countMetricsNames, (Object[])rateMetricsNames), metricsSums.length);
        return metricsMap;
    }

    private void processMetric(String metricName, String tableName, JsonNode metricNode, Map<String, JsonNode>[] tableMetricsMaps) {
        if (metricNode == null) {
            return;
        }
        boolean SOURCE_COUNT_IDX = false;
        boolean SINK_COUNT_IDX = true;
        int SOURCE_BYTES_IDX = 2;
        int SINK_BYTES_IDX = 3;
        int SOURCE_QPS_IDX = 4;
        int SINK_QPS_IDX = 5;
        int SOURCE_BYTES_SEC_IDX = 6;
        int SINK_BYTES_SEC_IDX = 7;
        if (metricName.startsWith("SourceReceivedCount#")) {
            tableMetricsMaps[0].put(tableName, metricNode);
        } else if (metricName.startsWith("SinkWriteCount#")) {
            tableMetricsMaps[1].put(tableName, metricNode);
        } else if (metricName.startsWith("SourceReceivedBytes#")) {
            tableMetricsMaps[2].put(tableName, metricNode);
        } else if (metricName.startsWith("SinkWriteBytes#")) {
            tableMetricsMaps[3].put(tableName, metricNode);
        } else if (metricName.startsWith("SourceReceivedQPS#")) {
            tableMetricsMaps[4].put(tableName, metricNode);
        } else if (metricName.startsWith("SinkWriteQPS#")) {
            tableMetricsMaps[5].put(tableName, metricNode);
        } else if (metricName.startsWith("SourceReceivedBytesPerSeconds#")) {
            tableMetricsMaps[6].put(tableName, metricNode);
        } else if (metricName.startsWith("SinkWriteBytesPerSeconds#")) {
            tableMetricsMaps[7].put(tableName, metricNode);
        }
    }

    private void aggregateMetrics(JsonNode jobMetricsStr, Long[] metricsSums, Double[] metricsRates, String[] metricsNames) {
        for (int i = 0; i < metricsNames.length; ++i) {
            JsonNode metricNode = jobMetricsStr.get(metricsNames[i]);
            if (metricNode == null || !metricNode.isArray()) continue;
            for (JsonNode node : metricNode) {
                int n;
                Number[] numberArray;
                if (i < metricsSums.length) {
                    numberArray = metricsSums;
                    n = i;
                    Long.valueOf((Long)numberArray[n] + node.path("value").asLong());
                    continue;
                }
                numberArray = metricsRates;
                n = i - metricsSums.length;
                Double.valueOf((Double)numberArray[n] + node.path("value").asDouble());
            }
        }
    }

    private void populateMetricsMap(Map<String, Object> metricsMap, Object[] metrics, String[] metricNames, int countMetricNames) {
        for (int i = 0; i < metrics.length; ++i) {
            if (metrics[i] == null) continue;
            if (metrics[i] instanceof Map) {
                metricsMap.put(metricNames[i], RestHttpGetCommandProcessor.aggregateMap((Map)metrics[i], i >= countMetricNames));
                continue;
            }
            metricsMap.put(metricNames[i], metrics[i]);
        }
    }

    public static Map<String, Object> aggregateMap(Map<String, JsonNode> inputMap, boolean isRate) {
        return isRate ? inputMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StreamSupport.stream(((JsonNode)entry.getValue()).spliterator(), false).mapToDouble(node -> node.path("value").asDouble()).sum())) : inputMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StreamSupport.stream(((JsonNode)entry.getValue()).spliterator(), false).mapToLong(node -> node.path("value").asLong()).sum()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMetrics(HttpGetCommand httpGetCommand, String contentType) {
        StringWriter stringWriter = new StringWriter();
        NodeExtension nodeExtension = (NodeExtension)this.textCommandService.getNode().getNodeExtension();
        try {
            TextFormat.writeFormat((String)contentType, (Writer)stringWriter, (Enumeration)nodeExtension.getCollectorRegistry().metricFamilySamples());
            this.prepareResponse((HttpCommand)httpGetCommand, stringWriter.toString());
        }
        catch (IOException e) {
            httpGetCommand.send400();
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException e) {
                this.logger.warning("An error occurred while handling request " + httpGetCommand, (Throwable)e);
                this.prepareResponse(HttpStatusCode.SC_500, (HttpCommand)httpGetCommand, RestHttpGetCommandProcessor.exceptionResponse((Throwable)e));
            }
        }
    }

    private SeaTunnelServer getSeaTunnelServer(boolean shouldBeMaster) {
        Map extensionServices = this.textCommandService.getNode().getNodeExtension().createExtensionServices();
        SeaTunnelServer seaTunnelServer = (SeaTunnelServer)extensionServices.get("st:impl:seaTunnelServer");
        if (shouldBeMaster && !seaTunnelServer.isMasterNode()) {
            return null;
        }
        return seaTunnelServer;
    }

    private JsonObject convertToJson(JobInfo jobInfo, long jobId) {
        JobStatus jobStatus;
        String jobMetrics;
        JsonObject jobInfoJson = new JsonObject();
        JobImmutableInformation jobImmutableInformation = (JobImmutableInformation)this.textCommandService.getNode().getNodeEngine().getSerializationService().toObject(this.textCommandService.getNode().getNodeEngine().getSerializationService().toObject((Object)jobInfo.getJobImmutableInformation()));
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(true);
        ClassLoaderService classLoaderService = seaTunnelServer == null ? this.getSeaTunnelServer(false).getClassLoaderService() : seaTunnelServer.getClassLoaderService();
        ClassLoader classLoader = classLoaderService.getClassLoader(jobId, (Collection)jobImmutableInformation.getPluginJarsUrls());
        LogicalDag logicalDag = (LogicalDag)CustomClassLoadedObject.deserializeWithCustomClassLoader((SerializationService)this.textCommandService.getNode().getNodeEngine().getSerializationService(), (ClassLoader)classLoader, (Data)jobImmutableInformation.getLogicalDag());
        classLoaderService.releaseClassLoader(jobId, (Collection)jobImmutableInformation.getPluginJarsUrls());
        if (seaTunnelServer == null) {
            jobMetrics = (String)NodeEngineUtil.sendOperationToMasterNode((NodeEngine)this.getNode().nodeEngine, new GetJobMetricsOperation(jobId)).join();
            jobStatus = JobStatus.values()[(Integer)NodeEngineUtil.sendOperationToMasterNode((NodeEngine)this.getNode().nodeEngine, new GetJobStatusOperation(jobId)).join()];
        } else {
            jobMetrics = seaTunnelServer.getCoordinatorService().getJobMetrics(jobId).toJsonString();
            jobStatus = seaTunnelServer.getCoordinatorService().getJobStatus(jobId);
        }
        jobInfoJson.add("jobId", String.valueOf(jobId)).add("jobName", logicalDag.getJobConfig().getName()).add("jobStatus", jobStatus.toString()).add("envOptions", (JsonValue)JsonUtil.toJsonObject((Map)logicalDag.getJobConfig().getEnvOptions())).add("createTime", DateTimeUtils.toString((long)jobImmutableInformation.getCreateTime(), (DateTimeUtils.Formatter)DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS)).add("jobDag", (JsonValue)logicalDag.getLogicalDagAsJson()).add("pluginJarsUrls", (JsonValue)jobImmutableInformation.getPluginJarsUrls().stream().map(url -> {
            JsonObject jarUrl = new JsonObject();
            jarUrl.add("jarPath", url.toString());
            return jarUrl;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add)).add("isStartWithSavePoint", jobImmutableInformation.isStartWithSavePoint()).add("metrics", (JsonValue)this.toJsonObject(this.getJobMetrics(jobMetrics)));
        return jobInfoJson;
    }

    private JsonObject toJsonObject(Map<String, Object> jobMetrics) {
        JsonObject members = new JsonObject();
        jobMetrics.forEach((key, value) -> {
            if (value instanceof Map) {
                members.add(key, (JsonValue)this.toJsonObject((Map)value));
            } else {
                members.add(key, value.toString());
            }
        });
        return members;
    }

    private JsonObject getJobInfoJson(JobHistoryService.JobState jobState, String jobMetrics, JobDAGInfo jobDAGInfo) {
        return new JsonObject().add("jobId", String.valueOf(jobState.getJobId())).add("jobName", jobState.getJobName()).add("jobStatus", jobState.getJobStatus().toString()).add("errorMsg", jobState.getErrorMessage()).add("createTime", DateTimeUtils.toString((long)jobState.getSubmitTime(), (DateTimeUtils.Formatter)DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS)).add("finishTime", DateTimeUtils.toString((long)jobState.getFinishTime(), (DateTimeUtils.Formatter)DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS)).add("jobDag", JsonUtils.toJsonString((Object)jobDAGInfo)).add("pluginJarsUrls", (JsonValue)new JsonArray()).add("metrics", (JsonValue)this.toJsonObject(this.getJobMetrics(jobMetrics)));
    }

    private /* synthetic */ void lambda$getJobMetrics$14(JsonNode jobMetricsStr, Map[] tableMetricsMaps, String metricName) {
        if (metricName.contains("#")) {
            String tableName = TablePath.of((String)metricName.split("#")[1]).getFullName();
            JsonNode metricNode = jobMetricsStr.get(metricName);
            this.processMetric(metricName, tableName, metricNode, tableMetricsMaps);
        }
    }
}

