/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.metrics;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.logging.ILogger;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.seatunnel.api.common.metrics.RawJobMetrics;
import org.apache.seatunnel.engine.server.metrics.JobMetricsUtil;

public class ZetaMetricsCollector
implements MetricsCollector {
    private final Predicate<MetricDescriptor> metricDescriptorPredicate;
    private final MetricsCompressor compressor;
    private final ILogger logger;
    private final UnaryOperator<MetricDescriptor> addPrefixFn;

    public ZetaMetricsCollector(Predicate<MetricDescriptor> metricDescriptorPredicate, Member member, ILogger logger) {
        Objects.requireNonNull(member, "member");
        this.logger = Objects.requireNonNull(logger, "logger");
        this.metricDescriptorPredicate = metricDescriptorPredicate;
        this.addPrefixFn = JobMetricsUtil.addMemberPrefixFn(member);
        this.compressor = new MetricsCompressor();
    }

    public void collectLong(MetricDescriptor descriptor, long value) {
        if (this.metricDescriptorPredicate.test(descriptor)) {
            this.compressor.addLong((MetricDescriptor)this.addPrefixFn.apply(descriptor), value);
        }
    }

    public void collectDouble(MetricDescriptor descriptor, double value) {
        if (this.metricDescriptorPredicate.test(descriptor)) {
            this.compressor.addDouble((MetricDescriptor)this.addPrefixFn.apply(descriptor), value);
        }
    }

    public void collectException(MetricDescriptor descriptor, Exception e) {
        if (this.metricDescriptorPredicate.test(descriptor)) {
            this.logger.warning("Exception when rendering job metrics: " + e, (Throwable)e);
        }
    }

    public void collectNoValue(MetricDescriptor descriptor) {
    }

    public RawJobMetrics getMetrics() {
        return RawJobMetrics.of((byte[])this.compressor.getBlobAndReset());
    }
}

