/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.metrics;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.logging.ILogger;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.metrics.RawJobMetrics;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.metrics.JobMetricsUtil;

public class JobMetricsCollector
implements MetricsCollector {
    private final List<String> taskGroupLocationStrs;
    private final MetricsCompressor compressor;
    private final ILogger logger;
    private final UnaryOperator<MetricDescriptor> addPrefixFn;

    public JobMetricsCollector(TaskGroupLocation taskGroupLocation, Member member, ILogger logger) {
        Objects.requireNonNull(member, "member");
        this.logger = Objects.requireNonNull(logger, "logger");
        this.taskGroupLocationStrs = Collections.singletonList(taskGroupLocation.toString());
        this.addPrefixFn = JobMetricsUtil.addMemberPrefixFn(member);
        this.compressor = new MetricsCompressor();
    }

    public JobMetricsCollector(List<TaskGroupLocation> taskGroupLocations, Member member, ILogger logger) {
        Objects.requireNonNull(member, "member");
        this.logger = Objects.requireNonNull(logger, "logger");
        this.taskGroupLocationStrs = taskGroupLocations.stream().map(TaskGroupLocation::toString).collect(Collectors.toList());
        this.addPrefixFn = JobMetricsUtil.addMemberPrefixFn(member);
        this.compressor = new MetricsCompressor();
    }

    public void collectLong(MetricDescriptor descriptor, long value) {
        String taskGroupLocationStr = JobMetricsUtil.getTaskGroupLocationFromMetricsDescriptor(descriptor);
        if (this.taskGroupLocationStrs.contains(taskGroupLocationStr)) {
            this.compressor.addLong((MetricDescriptor)this.addPrefixFn.apply(descriptor), value);
        }
    }

    public void collectDouble(MetricDescriptor descriptor, double value) {
        String taskGroupLocationStr = JobMetricsUtil.getTaskGroupLocationFromMetricsDescriptor(descriptor);
        if (this.taskGroupLocationStrs.contains(taskGroupLocationStr)) {
            this.compressor.addDouble((MetricDescriptor)this.addPrefixFn.apply(descriptor), value);
        }
    }

    public void collectException(MetricDescriptor descriptor, Exception e) {
        String taskGroupLocationStr = JobMetricsUtil.getTaskGroupLocationFromMetricsDescriptor(descriptor);
        if (this.taskGroupLocationStrs.contains(taskGroupLocationStr)) {
            this.logger.warning("Exception when rendering job metrics: " + e, (Throwable)e);
        }
    }

    public void collectNoValue(MetricDescriptor descriptor) {
    }

    public RawJobMetrics getMetrics() {
        return RawJobMetrics.of((byte[])this.compressor.getBlobAndReset());
    }
}

