/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.ActionUtils;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalVertex;
import org.apache.seatunnel.engine.core.job.Edge;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.VertexInfo;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionPlanGenerator;
import org.apache.seatunnel.engine.server.dag.execution.Pipeline;

public class DAGUtils {
    public static JobDAGInfo getJobDAGInfo(LogicalDag logicalDag, JobImmutableInformation jobImmutableInformation, EngineConfig engineConfig, boolean isPhysicalDAGIInfo) {
        List<Pipeline> pipelines = new ExecutionPlanGenerator(logicalDag, jobImmutableInformation, engineConfig).generate().getPipelines();
        if (isPhysicalDAGIInfo) {
            HashMap pipelineWithEdges = new HashMap();
            HashMap vertexInfoMap = new HashMap();
            pipelines.forEach(pipeline -> {
                pipelineWithEdges.put(pipeline.getId(), pipeline.getEdges().stream().map(e -> new Edge(e.getLeftVertexId(), e.getRightVertexId())).collect(Collectors.toList()));
                pipeline.getVertexes().forEach((id, vertex) -> vertexInfoMap.put(id, new VertexInfo(vertex.getVertexId().longValue(), ActionUtils.getActionType((Action)vertex.getAction()), vertex.getAction().getName())));
            });
            return new JobDAGInfo(Long.valueOf(jobImmutableInformation.getJobId()), pipelineWithEdges, vertexInfoMap);
        }
        List edges = logicalDag.getEdges().stream().map(e -> new Edge(e.getInputVertexId(), e.getTargetVertexId())).collect(Collectors.toList());
        Map logicalVertexMap = logicalDag.getLogicalVertexMap();
        Map vertexInfoMap = logicalVertexMap.values().stream().map(v -> new VertexInfo(v.getVertexId().longValue(), ActionUtils.getActionType((Action)v.getAction()), v.getAction().getName())).collect(Collectors.toMap(VertexInfo::getVertexId, Function.identity()));
        Map pipelineWithEdges = edges.stream().collect(Collectors.groupingBy(e -> {
            LogicalVertex info = (LogicalVertex)logicalVertexMap.get(e.getInputVertexId() != null ? e.getInputVertexId() : e.getTargetVertexId());
            return pipelines.stream().filter(p -> p.getActions().containsKey(info.getAction().getId())).findFirst().get().getId();
        }, Collectors.toList()));
        return new JobDAGInfo(Long.valueOf(jobImmutableInformation.getJobId()), pipelineWithEdges, vertexInfoMap);
    }
}

