/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointErrorReportOperation;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskGroupContext;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.CheckpointDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyTaskRestoreOperation
extends TaskOperation {
    private static final Logger log = LoggerFactory.getLogger(NotifyTaskRestoreOperation.class);
    private List<ActionSubtaskState> restoredState;

    public NotifyTaskRestoreOperation(TaskLocation taskLocation, List<ActionSubtaskState> restoredState) {
        super(taskLocation);
        this.restoredState = restoredState;
    }

    public int getFactoryId() {
        return CheckpointDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 5;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.restoredState.size());
        for (ActionSubtaskState state : this.restoredState) {
            out.writeObject((Object)state);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.restoredState = new ArrayList<ActionSubtaskState>(size);
        for (int i = 0; i < size; ++i) {
            this.restoredState.add((ActionSubtaskState)in.readObject());
        }
    }

    @Override
    public void runInternal() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            log.debug("NotifyTaskRestoreOperation " + this.taskLocation);
            TaskGroupContext groupContext = server.getTaskExecutionService().getExecutionContext(this.taskLocation.getTaskGroupLocation());
            Object task = groupContext.getTaskGroup().getTask(this.taskLocation.getTaskID());
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                task.getExecutionContext().getTaskExecutionService().asyncExecuteFunction(this.taskLocation.getTaskGroupLocation(), () -> {
                    Thread.currentThread().setContextClassLoader(groupContext.getClassLoader(task.getTaskID()));
                    try {
                        log.debug("NotifyTaskRestoreOperation.restoreState " + this.restoredState);
                        task.restoreState(this.restoredState);
                        log.debug("NotifyTaskRestoreOperation.finished " + this.restoredState);
                    }
                    catch (Throwable e) {
                        task.getExecutionContext().sendToMaster(new CheckpointErrorReportOperation(this.taskLocation, e));
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(classLoader);
                    }
                });
            }
            catch (Exception e) {
                throw new SeaTunnelException((Throwable)e);
            }
            return null;
        }, (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.taskLocation.getTaskGroupLocation()), 2000L));
    }

    public NotifyTaskRestoreOperation() {
    }
}

