/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.impl.DefaultNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.ascii.TextCommandConstants;
import com.hazelcast.internal.ascii.TextCommandProcessor;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.TextCommandServiceImpl;
import io.prometheus.client.CollectorRegistry;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.server.NodeExtensionCommon;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.log.Log4j2HttpGetCommandProcessor;
import org.apache.seatunnel.engine.server.log.Log4j2HttpPostCommandProcessor;
import org.apache.seatunnel.engine.server.rest.RestHttpGetCommandProcessor;
import org.apache.seatunnel.engine.server.rest.RestHttpPostCommandProcessor;

public class NodeExtension
extends DefaultNodeExtension {
    private final NodeExtensionCommon extCommon;
    private final CollectorRegistry collectorRegistry;

    public NodeExtension(@NonNull Node node, @NonNull SeaTunnelConfig seaTunnelConfig) {
        super(node);
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        this.extCommon = new NodeExtensionCommon(node, new SeaTunnelServer(seaTunnelConfig));
        this.collectorRegistry = CollectorRegistry.defaultRegistry;
    }

    public void beforeStart() {
        super.beforeStart();
    }

    public void afterStart() {
        super.afterStart();
        this.extCommon.afterStart();
    }

    public void beforeClusterStateChange(ClusterState currState, ClusterState requestedState, boolean isTransient) {
        super.beforeClusterStateChange(currState, requestedState, isTransient);
        this.extCommon.beforeClusterStateChange(requestedState);
    }

    public void onClusterStateChange(ClusterState newState, boolean isTransient) {
        super.onClusterStateChange(newState, isTransient);
        this.extCommon.onClusterStateChange(newState);
    }

    public Map<String, Object> createExtensionServices() {
        return this.extCommon.createExtensionServices();
    }

    public TextCommandService createTextCommandService() {
        return new TextCommandServiceImpl(this.node){
            {
                this.register(TextCommandConstants.TextCommandType.HTTP_GET, (TextCommandProcessor)new Log4j2HttpGetCommandProcessor((TextCommandService)this));
                this.register(TextCommandConstants.TextCommandType.HTTP_POST, (TextCommandProcessor)new Log4j2HttpPostCommandProcessor((TextCommandService)this));
                this.register(TextCommandConstants.TextCommandType.HTTP_GET, (TextCommandProcessor)new RestHttpGetCommandProcessor((TextCommandService)this));
                this.register(TextCommandConstants.TextCommandType.HTTP_POST, (TextCommandProcessor)new RestHttpPostCommandProcessor((TextCommandService)this));
            }
        };
    }

    public void printNodeInfo() {
        this.extCommon.printNodeInfo(this.systemLogger);
    }

    public CollectorRegistry getCollectorRegistry() {
        return this.collectorRegistry;
    }
}

