/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration.util;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionMark;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;

public class OptionUtil {
    private OptionUtil() {
    }

    public static String getOptionKeys(List<Option<?>> options) {
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (Option<?> option : options) {
            if (flag) {
                builder.append(", ");
            }
            builder.append("'").append(option.key()).append("'");
            flag = true;
        }
        return builder.toString();
    }

    public static String getOptionKeys(List<Option<?>> options, List<RequiredOption.BundledRequiredOptions> bundledOptions) {
        ArrayList optionList = new ArrayList();
        for (Option<?> option : options) {
            optionList.add(Collections.singletonList(option));
        }
        for (RequiredOption.BundledRequiredOptions bundledOption : bundledOptions) {
            optionList.add(bundledOption.getRequiredOption());
        }
        boolean flag = false;
        StringBuilder builder = new StringBuilder();
        for (List list : optionList) {
            if (flag) {
                builder.append(", ");
            }
            builder.append("[").append(OptionUtil.getOptionKeys(list)).append("]");
            flag = true;
        }
        return builder.toString();
    }

    public static List<Option<?>> getOptions(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList options = new ArrayList();
        Object object = clazz.newInstance();
        for (final Field field : fields) {
            field.setAccessible(true);
            OptionMark option = field.getAnnotation(OptionMark.class);
            if (option == null) continue;
            options.add(new Option<Object>(!StringUtils.isNotBlank((CharSequence)option.name()) ? OptionUtil.formatUnderScoreCase(field.getName()) : option.name(), new TypeReference<Object>(){

                public Type getType() {
                    return field.getType();
                }
            }, field.get(object)).withDescription(option.description()));
        }
        return options;
    }

    private static String formatUnderScoreCase(String camel) {
        StringBuilder underScore = new StringBuilder(String.valueOf(Character.toLowerCase(camel.charAt(0))));
        for (int i = 1; i < camel.length(); ++i) {
            char c = camel.charAt(i);
            underScore.append(Character.isLowerCase(c) ? Character.valueOf(c) : "_" + Character.toLowerCase(c));
        }
        return underScore.toString();
    }
}

