/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.starrocks;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.datasource.plugin.api.DataSourceChannel;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginException;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.datasource.plugin.starrocks.StarRocksCatalog;
import org.apache.seatunnel.datasource.plugin.starrocks.StarRocksOptionRule;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksDataSourceChannel
implements DataSourceChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarRocksDataSourceChannel.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public boolean canAbleGetSchema() {
        return true;
    }

    public OptionRule getDataSourceOptions(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return StarRocksOptionRule.optionRule();
    }

    public OptionRule getDatasourceMetadataFieldsByDataSourceName(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return StarRocksOptionRule.metadataRule();
    }

    public List<String> getTables(@NonNull String pluginName, Map<String, String> requestParams, String database, Map<String, String> option) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        StarRocksCatalog catalog = this.getCatalog(requestParams);
        return catalog.listTables(database);
    }

    public List<String> getDatabases(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        StarRocksCatalog catalog = this.getCatalog(requestParams);
        return catalog.listDatabases();
    }

    public boolean checkDataSourceConnectivity(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        try {
            StarRocksCatalog catalog = this.getCatalog(requestParams);
            String nodeUrls = requestParams.get(StarRocksOptionRule.NODE_URLS.key());
            List nodeList = (List)OBJECT_MAPPER.readValue(nodeUrls, List.class);
            if (!StarRocksDataSourceChannel.telnet((String)nodeList.get(0))) {
                return false;
            }
            catalog.listDatabases();
            return true;
        }
        catch (Exception e) {
            throw new DataSourcePluginException("check StarRocks connectivity failed, " + e.getMessage(), (Throwable)e);
        }
    }

    private static boolean telnet(String nodeUrl) throws IOException {
        boolean isConnected;
        Socket socket = new Socket();
        try {
            String[] hostAndPort = nodeUrl.split(":");
            socket.connect(new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1])), 1000);
            isConnected = socket.isConnected();
        }
        catch (IOException e) {
            LOGGER.error("telnet error", (Throwable)e);
            throw e;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                LOGGER.error("Release Socket Connection Error", (Throwable)e);
            }
        }
        return isConnected;
    }

    public List<TableField> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull String table) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        StarRocksCatalog catalog = this.getCatalog(requestParams);
        return catalog.getTable(TablePath.of((String)database, (String)table));
    }

    public Map<String, List<TableField>> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull List<String> tables) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tables == null) {
            throw new NullPointerException("tables is marked non-null but is null");
        }
        StarRocksCatalog catalog = this.getCatalog(requestParams);
        HashMap<String, List<TableField>> tableFields = new HashMap<String, List<TableField>>();
        tables.forEach(table -> tableFields.put((String)table, catalog.getTable(TablePath.of((String)database, (String)table))));
        return tableFields;
    }

    private StarRocksCatalog getCatalog(Map<String, String> requestParams) {
        try {
            String username = requestParams.get(StarRocksOptionRule.USERNAME.key());
            String password = requestParams.get(StarRocksOptionRule.PASSWORD.key());
            String jdbc = requestParams.get(StarRocksOptionRule.BASE_URL.key());
            return new StarRocksCatalog("StarRocks", username, password, jdbc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

