/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.s3;

import java.util.Arrays;
import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.util.OptionRule;

public class S3OptionRule {
    public static final Option<String> ACCESS_KEY = Options.key((String)"access_key").stringType().noDefaultValue().withDescription("S3 access key");
    public static final Option<String> SECRET_KEY = Options.key((String)"secret_key").stringType().noDefaultValue().withDescription("S3 secret key");
    public static final Option<String> BUCKET = Options.key((String)"bucket").stringType().noDefaultValue().withDescription("S3 bucket name");
    public static final Option<String> FS_S3A_ENDPOINT = Options.key((String)"fs.s3a.endpoint").stringType().noDefaultValue().withDescription("fs s3a endpoint");
    public static final Option<S3aAwsCredentialsProvider> S3A_AWS_CREDENTIALS_PROVIDER = Options.key((String)"fs.s3a.aws.credentials.provider").enumType(S3aAwsCredentialsProvider.class).defaultValue((Object)S3aAwsCredentialsProvider.InstanceProfileCredentialsProvider).withDescription("s3a aws credentials provider");
    public static final Option<Map<String, String>> HADOOP_S3_PROPERTIES = Options.key((String)"hadoop_s3_properties").mapType().noDefaultValue().withDescription("{\nfs.s3a.buffer.dir=/data/st_test/s3a\nfs.s3a.fast.upload.buffer=disk\n}");
    public static final Option<String> PATH = Options.key((String)"path").stringType().noDefaultValue().withDescription("S3 write path");
    public static final Option<FileFormat> TYPE = Options.key((String)"file_format_type").enumType(FileFormat.class).noDefaultValue().withDescription("S3 write type");
    public static final Option<String> DELIMITER = Options.key((String)"delimiter").stringType().noDefaultValue().withDescription("S3 write delimiter");
    public static final Option<Map<String, String>> SCHEMA = Options.key((String)"schema").mapType().noDefaultValue().withDescription("SeaTunnel Schema");
    public static final Option<Boolean> PARSE_PARSE_PARTITION_FROM_PATH = Options.key((String)"parse_partition_from_path").booleanType().noDefaultValue().withDescription("S3 write parse_partition_from_path");
    public static final Option<String> DATE_FORMAT = Options.key((String)"date_format").stringType().noDefaultValue().withDescription("S3 write date_format");
    public static final Option<String> DATETIME_FORMAT = Options.key((String)"time_format").stringType().noDefaultValue().withDescription("S3 write time_format");
    public static final Option<String> TIME_FORMAT = Options.key((String)"datetime_format").stringType().noDefaultValue().withDescription("S3 write datetime_format");

    public static OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{BUCKET, FS_S3A_ENDPOINT, S3A_AWS_CREDENTIALS_PROVIDER}).optional(new Option[]{HADOOP_S3_PROPERTIES}).conditional(S3A_AWS_CREDENTIALS_PROVIDER, (Object)S3aAwsCredentialsProvider.SimpleAWSCredentialsProvider, new Option[]{ACCESS_KEY, SECRET_KEY}).build();
    }

    public static OptionRule metadataRule() {
        return OptionRule.builder().required(new Option[]{PATH, TYPE}).conditional(TYPE, (Object)FileFormat.TEXT, new Option[]{DELIMITER}).conditional(TYPE, Arrays.asList(FileFormat.TEXT, FileFormat.JSON), new Option[]{SCHEMA}).optional(new Option[]{PARSE_PARSE_PARTITION_FROM_PATH}).optional(new Option[]{DATE_FORMAT}).optional(new Option[]{DATETIME_FORMAT}).optional(new Option[]{TIME_FORMAT}).build();
    }

    public static enum FileFormat {
        CSV("csv"),
        TEXT("txt"),
        PARQUET("parquet"),
        ORC("orc"),
        JSON("json");

        private final String type;

        private FileFormat(String type) {
            this.type = type;
        }
    }

    public static enum S3aAwsCredentialsProvider {
        SimpleAWSCredentialsProvider("org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider"),
        InstanceProfileCredentialsProvider("com.amazonaws.auth.InstanceProfileCredentialsProvider");

        private String provider;

        private S3aAwsCredentialsProvider(String provider) {
            this.provider = provider;
        }

        public String getProvider() {
            return this.provider;
        }

        public String toString() {
            return this.provider;
        }
    }
}

