/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.s3;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.datasource.plugin.api.DataSourceChannel;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginException;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.datasource.plugin.s3.HadoopS3AConfiguration;
import org.apache.seatunnel.datasource.plugin.s3.S3OptionRule;

public class S3DatasourceChannel
implements DataSourceChannel {
    public OptionRule getDataSourceOptions(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return S3OptionRule.optionRule();
    }

    public OptionRule getDatasourceMetadataFieldsByDataSourceName(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return S3OptionRule.metadataRule();
    }

    public List<String> getTables(@NonNull String pluginName, Map<String, String> requestParams, String database, Map<String, String> options) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        throw new UnsupportedOperationException("getTables is not supported for S3 datasource");
    }

    public List<String> getDatabases(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        throw new UnsupportedOperationException("getDatabases is not supported for S3 datasource");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDataSourceConnectivity(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        Configuration conf = HadoopS3AConfiguration.getConfiguration(requestParams);
        try (FileSystem fs = FileSystem.get((Configuration)conf);){
            fs.listStatus(new Path("/"));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new DataSourcePluginException(String.format("check s3 connectivity failed, config is: %s", requestParams), (Throwable)e);
        }
    }

    public List<TableField> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull String table) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        throw new UnsupportedOperationException("getTableFields is not supported for S3 datasource");
    }

    public Map<String, List<TableField>> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull List<String> tables) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tables == null) {
            throw new NullPointerException("tables is marked non-null but is null");
        }
        throw new UnsupportedOperationException("getTableFields is not supported for S3 datasource");
    }
}

