/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.s3;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.seatunnel.datasource.plugin.s3.S3OptionRule;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopS3AConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HadoopS3AConfiguration.class);
    private static final String S3A_SCHEMA = "s3a";
    private static final String HDFS_S3N_IMPL = "org.apache.hadoop.fs.s3native.NativeS3FileSystem";
    private static final String HDFS_S3A_IMPL = "org.apache.hadoop.fs.s3a.S3AFileSystem";
    private static final String S3A_PROTOCOL = "s3a";
    private static final String DEFAULT_PROTOCOL = "s3n";
    private static final String S3_FORMAT_KEY = "fs.%s.%s";
    private static final String HDFS_IMPL_KEY = "impl";

    public static Configuration getConfiguration(Map<String, String> s3Options) {
        if (!s3Options.containsKey(S3OptionRule.BUCKET.key())) {
            throw new IllegalArgumentException("S3 datasource bucket is null, please check your config");
        }
        if (!s3Options.containsKey(S3OptionRule.FS_S3A_ENDPOINT.key())) {
            throw new IllegalArgumentException("S3 datasource endpoint is null, please check your config");
        }
        String bucket = s3Options.get(S3OptionRule.BUCKET.key());
        String protocol = DEFAULT_PROTOCOL;
        if (bucket.startsWith("s3a")) {
            protocol = "s3a";
        }
        String fsImpl = protocol.equals("s3a") ? HDFS_S3A_IMPL : HDFS_S3N_IMPL;
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("fs.defaultFS", bucket);
        hadoopConf.set(S3OptionRule.FS_S3A_ENDPOINT.key(), s3Options.get(S3OptionRule.FS_S3A_ENDPOINT.key()));
        hadoopConf.set(HadoopS3AConfiguration.formatKey(protocol, HDFS_IMPL_KEY), fsImpl);
        if (s3Options.containsKey(S3OptionRule.HADOOP_S3_PROPERTIES.key())) {
            Config configObject = ConfigFactory.parseString((String)s3Options.get(S3OptionRule.HADOOP_S3_PROPERTIES.key()));
            configObject.entrySet().forEach(entry -> hadoopConf.set((String)entry.getKey(), ((ConfigValue)entry.getValue()).unwrapped().toString()));
        }
        if (S3OptionRule.S3aAwsCredentialsProvider.SimpleAWSCredentialsProvider.getProvider().equals(s3Options.get(S3OptionRule.S3A_AWS_CREDENTIALS_PROVIDER.key()))) {
            hadoopConf.set(S3OptionRule.S3A_AWS_CREDENTIALS_PROVIDER.key(), s3Options.get(S3OptionRule.S3A_AWS_CREDENTIALS_PROVIDER.key()));
            hadoopConf.set("fs.s3a.access.key", s3Options.get(S3OptionRule.ACCESS_KEY.key()));
            hadoopConf.set("fs.s3a.secret.key", s3Options.get(S3OptionRule.SECRET_KEY.key()));
        } else {
            hadoopConf.set(S3OptionRule.S3A_AWS_CREDENTIALS_PROVIDER.key(), s3Options.get(S3OptionRule.S3A_AWS_CREDENTIALS_PROVIDER.key()));
        }
        return hadoopConf;
    }

    private static String formatKey(String protocol, String key) {
        return String.format(S3_FORMAT_KEY, protocol, key);
    }
}

