/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.cdc.mysql;

import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.util.OptionRule;

public class MysqlCDCOptionRule {
    public static final Option<String> BASE_URL = Options.key((String)"base-url").stringType().noDefaultValue().withDescription("URL has to be without database, like \"jdbc:mysql://localhost:5432/\" or\"jdbc:mysql://localhost:5432\" rather than \"jdbc:mysql://localhost:5432/db\"");
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withDescription("Name of the database to use when connecting to the database server.");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the database server.");
    public static final Option<String> DATABASE_NAME = Options.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the database to monitor.");
    public static final Option<String> TABLE_NAME = Options.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the database to monitor.");
    public static final Option<String> SERVER_TIME_ZONE = Options.key((String)"server-time-zone").stringType().defaultValue((Object)"UTC").withDescription("The session time zone in database server.");

    public static OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{USERNAME, PASSWORD, BASE_URL}).optional(new Option[]{SERVER_TIME_ZONE}).build();
    }

    public static OptionRule metadataRule() {
        return OptionRule.builder().required(new Option[]{DATABASE_NAME, TABLE_NAME}).build();
    }
}

