/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.kafka;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Properties;
import org.apache.seatunnel.datasource.plugin.kafka.KafkaOptionRule;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;

public class KafkaRequestParamsUtils {
    public static Properties parsePropertiesFromRequestParams(Map<String, String> requestParams) {
        Preconditions.checkArgument((boolean)requestParams.containsKey(KafkaOptionRule.BOOTSTRAP_SERVERS.key()), (Object)String.format("Missing %s in requestParams", KafkaOptionRule.BOOTSTRAP_SERVERS.key()));
        Properties properties = new Properties();
        properties.put("bootstrap.servers", requestParams.get(KafkaOptionRule.BOOTSTRAP_SERVERS.key()));
        if (requestParams.containsKey(KafkaOptionRule.KAFKA_CONFIG.key())) {
            Config configObject = ConfigFactory.parseString((String)requestParams.get(KafkaOptionRule.KAFKA_CONFIG.key()));
            configObject.entrySet().forEach(entry -> properties.put(entry.getKey(), ((ConfigValue)entry.getValue()).unwrapped().toString()));
        }
        return properties;
    }
}

