/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.kafka;

import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.util.OptionRule;

public class KafkaOptionRule {
    public static final Option<String> BOOTSTRAP_SERVERS = Options.key((String)"bootstrap.servers").stringType().noDefaultValue().withDescription("Kafka cluster address, separated by \",\".");
    public static final Option<String> TOPIC = Options.key((String)"topic").stringType().noDefaultValue().withDescription("Kafka topic name. If there are multiple topics, use , to split, for example: \"tpc1,tpc2\".");
    public static final Option<Boolean> PATTERN = Options.key((String)"pattern").booleanType().defaultValue((Object)false).withDescription("If pattern is set to true,the regular expression for a pattern of topic names to read from. All topics in clients with names that match the specified regular expression will be subscribed by the consumer.");
    public static final Option<Map<String, String>> KAFKA_CONFIG = Options.key((String)"kafka.config").mapType().noDefaultValue().withDescription("{\nclient.id=client_1\nmax.poll.records=500\nauto.offset.reset=earliest\nenable.auto.commit=false\n}");

    public static OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{BOOTSTRAP_SERVERS}).optional(new Option[]{KAFKA_CONFIG}).build();
    }

    public static OptionRule metadataRule() {
        return OptionRule.builder().required(new Option[]{TOPIC}).optional(new Option[]{PATTERN}).build();
    }
}

