/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.kafka;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.datasource.plugin.api.DataSourceChannel;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginException;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.datasource.plugin.kafka.KafkaOptionRule;
import org.apache.seatunnel.datasource.plugin.kafka.KafkaRequestParamsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaDataSourceChannel
implements DataSourceChannel {
    private static final Logger log = LoggerFactory.getLogger(KafkaDataSourceChannel.class);
    private static final String DATABASE = "default";
    private static final DescribeClusterOptions DEFAULT_TIMEOUT_OPTIONS = new DescribeClusterOptions().timeoutMs(60000);

    public OptionRule getDataSourceOptions(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return KafkaOptionRule.optionRule();
    }

    public OptionRule getDatasourceMetadataFieldsByDataSourceName(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return KafkaOptionRule.metadataRule();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getTables(@NonNull String pluginName, Map<String, String> requestParams, String database, Map<String, String> option) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)StringUtils.equalsIgnoreCase(database, DATABASE), (Object)"database must be default");
        try (AdminClient adminClient = this.createAdminClient(requestParams);){
            Set<String> strings = adminClient.listTopics().names().get();
            ArrayList<String> arrayList = new ArrayList<String>(strings);
            return arrayList;
        }
        catch (Exception ex) {
            throw new DataSourcePluginException("check kafka connectivity failed, " + ex.getMessage(), (Throwable)ex);
        }
    }

    public List<String> getDatabases(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        return DEFAULT_DATABASES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDataSourceConnectivity(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        try (AdminClient adminClient = this.createAdminClient(requestParams);){
            DescribeClusterResult describeClusterResult = adminClient.describeCluster(DEFAULT_TIMEOUT_OPTIONS);
            boolean bl = CollectionUtils.isNotEmpty(describeClusterResult.nodes().get());
            return bl;
        }
        catch (Exception ex) {
            throw new DataSourcePluginException("check kafka connectivity failed, " + ex.getMessage(), (Throwable)ex);
        }
    }

    public List<TableField> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull String table) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)StringUtils.equalsIgnoreCase(database, DATABASE), (Object)"database must be default");
        return Collections.emptyList();
    }

    public Map<String, List<TableField>> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull List<String> tables) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tables == null) {
            throw new NullPointerException("tables is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)StringUtils.equalsIgnoreCase(database, DATABASE), (Object)"database must be default");
        return Collections.emptyMap();
    }

    private AdminClient createAdminClient(Map<String, String> requestParams) {
        return AdminClient.create(KafkaRequestParamsUtils.parsePropertiesFromRequestParams(requestParams));
    }
}

