/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.hive.jdbc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.datasource.plugin.api.DataSourceChannel;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginException;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.datasource.plugin.hive.jdbc.HiveJdbcOptionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveJdbcDataSourceChannel
implements DataSourceChannel {
    private static final Logger log = LoggerFactory.getLogger(HiveJdbcDataSourceChannel.class);

    public OptionRule getDataSourceOptions(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return HiveJdbcOptionRule.optionRule();
    }

    public OptionRule getDatasourceMetadataFieldsByDataSourceName(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return HiveJdbcOptionRule.metadataRule();
    }

    public List<String> getTables(@NonNull String pluginName, Map<String, String> requestParams, String database, Map<String, String> option) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return this.getTables(pluginName, requestParams, database, option);
    }

    public List<String> getDatabases(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        try {
            return this.getDataBaseNames(pluginName, requestParams);
        }
        catch (SQLException e) {
            log.error("Query Hive databases error, request params is {}", requestParams, (Object)e);
            throw new DataSourcePluginException("Query Hive databases error,", (Throwable)e);
        }
    }

    public boolean checkDataSourceConnectivity(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        return this.checkJdbcConnectivity(requestParams);
    }

    public List<TableField> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull String table) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        return this.getTableFields(requestParams, database, table);
    }

    public Map<String, List<TableField>> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull List<String> tables) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tables == null) {
            throw new NullPointerException("tables is marked non-null but is null");
        }
        HashMap<String, List<TableField>> tableFields = new HashMap<String, List<TableField>>(tables.size());
        for (String table : tables) {
            tableFields.put(table, this.getTableFields(requestParams, database, table));
        }
        return tableFields;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkJdbcConnectivity(Map<String, String> requestParams) {
        try (Connection ignored = this.init(requestParams);){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DataSourcePluginException("check jdbc connectivity failed, " + e.getMessage(), (Throwable)e);
        }
    }

    protected Connection init(Map<String, String> requestParams) throws SQLException {
        if (MapUtils.isEmpty(requestParams)) {
            throw new DataSourcePluginException("Hive jdbc request params is null, please check your config");
        }
        String url = requestParams.get(HiveJdbcOptionRule.URL.key());
        return DriverManager.getConnection(url);
    }

    /*
     * Exception decompiling
     */
    protected List<String> getDataBaseNames(String pluginName, Map<String, String> requestParams) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> getTableNames(Map<String, String> requestParams, String dbName) {
        ArrayList<String> tableNames = new ArrayList<String>();
        try (Connection connection = this.init(requestParams);){
            ResultSet resultSet = connection.getMetaData().getTables(dbName, null, null, new String[]{"TABLE"});
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                if (!StringUtils.isNotBlank(tableName)) continue;
                tableNames.add(tableName);
            }
            ArrayList<String> arrayList = tableNames;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DataSourcePluginException("get table names failed", (Throwable)e);
        }
    }

    protected List<TableField> getTableFields(Map<String, String> requestParams, String dbName, String tableName) {
        ArrayList<TableField> tableFields = new ArrayList<TableField>();
        try (Connection connection = this.init(requestParams);){
            DatabaseMetaData metaData = connection.getMetaData();
            String primaryKey = this.getPrimaryKey(metaData, dbName, tableName);
            ResultSet resultSet = metaData.getColumns(dbName, null, tableName, null);
            while (resultSet.next()) {
                TableField tableField = new TableField();
                String columnName = resultSet.getString("COLUMN_NAME");
                tableField.setPrimaryKey(Boolean.valueOf(false));
                if (StringUtils.isNotBlank(primaryKey) && primaryKey.equals(columnName)) {
                    tableField.setPrimaryKey(Boolean.valueOf(true));
                }
                tableField.setName(columnName);
                tableField.setType(resultSet.getString("TYPE_NAME"));
                tableField.setComment(resultSet.getString("REMARKS"));
                Object nullable = resultSet.getObject("IS_NULLABLE");
                boolean isNullable = this.convertToBoolean(nullable);
                tableField.setNullable(Boolean.valueOf(isNullable));
                tableFields.add(tableField);
            }
        }
        catch (SQLException e) {
            throw new DataSourcePluginException("get table fields failed", (Throwable)e);
        }
        return tableFields;
    }

    private String getPrimaryKey(DatabaseMetaData metaData, String dbName, String tableName) throws SQLException {
        ResultSet primaryKeysInfo = metaData.getPrimaryKeys(dbName, "%", tableName);
        if (primaryKeysInfo.next()) {
            return primaryKeysInfo.getString("COLUMN_NAME");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkHostConnectable(String host, int port) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), 1000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isNotSystemDatabase(String pluginName, String dbName) {
        return true;
    }

    private boolean convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return value.equals("TRUE");
        }
        return false;
    }
}

