/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.SignedRawTransaction;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.utils.Numeric;

public class TransactionDecoder {
    public static RawTransaction decode(String hexTransaction) {
        byte[] transaction = Numeric.hexStringToByteArray(hexTransaction);
        RlpList rlpList = RlpDecoder.decode(transaction);
        RlpList values2 = (RlpList)rlpList.getValues().get(0);
        BigInteger nonce = ((RlpString)values2.getValues().get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values2.getValues().get(1)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values2.getValues().get(2)).asPositiveBigInteger();
        String to = ((RlpString)values2.getValues().get(3)).asString();
        BigInteger value = ((RlpString)values2.getValues().get(4)).asPositiveBigInteger();
        String data = ((RlpString)values2.getValues().get(5)).asString();
        if (values2.getValues().size() == 6 || values2.getValues().size() == 8 && ((RlpString)values2.getValues().get(7)).getBytes().length == 10 || values2.getValues().size() == 9 && ((RlpString)values2.getValues().get(8)).getBytes().length == 10) {
            return RawTransaction.createTransaction(nonce, gasPrice, gasLimit, to, value, data);
        }
        byte[] v = ((RlpString)values2.getValues().get(6)).getBytes();
        byte[] r = Numeric.toBytesPadded(Numeric.toBigInt(((RlpString)values2.getValues().get(7)).getBytes()), 32);
        byte[] s = Numeric.toBytesPadded(Numeric.toBigInt(((RlpString)values2.getValues().get(8)).getBytes()), 32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
        return new SignedRawTransaction(nonce, gasPrice, gasLimit, to, value, data, signatureData);
    }
}

