/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.tdengine.typemapper;

import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.tdengine.exception.TDengineConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDengineTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(TDengineTypeMapper.class);
    private static final String TDENGINE_UNKNOWN = "UNKNOWN";
    private static final String TDENGINE_BIT = "BIT";
    private static final String TDENGINE_BOOL = "BOOL";
    private static final String TDENGINE_TINYINT = "TINYINT";
    private static final String TDENGINE_TINYINT_UNSIGNED = "TINYINT UNSIGNED";
    private static final String TDENGINE_SMALLINT = "SMALLINT";
    private static final String TDENGINE_SMALLINT_UNSIGNED = "SMALLINT UNSIGNED";
    private static final String TDENGINE_MEDIUMINT = "MEDIUMINT";
    private static final String TDENGINE_MEDIUMINT_UNSIGNED = "MEDIUMINT UNSIGNED";
    private static final String TDENGINE_INT = "INT";
    private static final String TDENGINE_INT_UNSIGNED = "INT UNSIGNED";
    private static final String TDENGINE_INTEGER = "INTEGER";
    private static final String TDENGINE_INTEGER_UNSIGNED = "INTEGER UNSIGNED";
    private static final String TDENGINE_BIGINT = "BIGINT";
    private static final String TDENGINE_BIGINT_UNSIGNED = "BIGINT UNSIGNED";
    private static final String TDENGINE_DECIMAL = "DECIMAL";
    private static final String TDENGINE_DECIMAL_UNSIGNED = "DECIMAL UNSIGNED";
    private static final String TDENGINE_FLOAT = "FLOAT";
    private static final String TDENGINE_FLOAT_UNSIGNED = "FLOAT UNSIGNED";
    private static final String TDENGINE_DOUBLE = "DOUBLE";
    private static final String TDENGINE_DOUBLE_UNSIGNED = "DOUBLE UNSIGNED";
    private static final String TDENGINE_CHAR = "CHAR";
    private static final String TDENGINE_VARCHAR = "VARCHAR";
    private static final String TDENGINE_TINYTEXT = "TINYTEXT";
    private static final String TDENGINE_MEDIUMTEXT = "MEDIUMTEXT";
    private static final String TDENGINE_TEXT = "TEXT";
    private static final String TDENGINE_LONGTEXT = "LONGTEXT";
    private static final String TDENGINE_JSON = "JSON";
    private static final String TDENGINE_DATE = "DATE";
    private static final String TDENGINE_DATETIME = "DATETIME";
    private static final String TDENGINE_TIME = "TIME";
    private static final String TDENGINE_TIMESTAMP = "TIMESTAMP";
    private static final String TDENGINE_YEAR = "YEAR";
    private static final String TDENGINE_TINYBLOB = "TINYBLOB";
    private static final String TDENGINE_MEDIUMBLOB = "MEDIUMBLOB";
    private static final String TDENGINE_BLOB = "BLOB";
    private static final String TDENGINE_LONGBLOB = "LONGBLOB";
    private static final String TDENGINE_BINARY = "BINARY";
    private static final String TDENGINE_VARBINARY = "VARBINARY";
    private static final String TDENGINE_GEOMETRY = "GEOMETRY";

    public static SeaTunnelDataType<?> mapping(String tdengineType) {
        switch (tdengineType) {
            case "BOOL": 
            case "BIT": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "TINYINT": 
            case "TINYINT UNSIGNED": 
            case "SMALLINT": 
            case "SMALLINT UNSIGNED": 
            case "MEDIUMINT": 
            case "MEDIUMINT UNSIGNED": 
            case "INT": 
            case "INTEGER": 
            case "YEAR": {
                return BasicType.INT_TYPE;
            }
            case "INT UNSIGNED": 
            case "INTEGER UNSIGNED": 
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "BIGINT UNSIGNED": {
                return new DecimalType(20, 0);
            }
            case "DECIMAL": {
                log.warn("{} will probably cause value overflow.", (Object)TDENGINE_DECIMAL);
                return new DecimalType(38, 18);
            }
            case "DECIMAL UNSIGNED": {
                return new DecimalType(38, 18);
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "FLOAT UNSIGNED": {
                log.warn("{} will probably cause value overflow.", (Object)TDENGINE_FLOAT_UNSIGNED);
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "DOUBLE UNSIGNED": {
                log.warn("{} will probably cause value overflow.", (Object)TDENGINE_DOUBLE_UNSIGNED);
                return BasicType.DOUBLE_TYPE;
            }
            case "CHAR": 
            case "TINYTEXT": 
            case "MEDIUMTEXT": 
            case "TEXT": 
            case "VARCHAR": 
            case "JSON": 
            case "LONGTEXT": {
                return BasicType.STRING_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "TINYBLOB": 
            case "MEDIUMBLOB": 
            case "BLOB": 
            case "LONGBLOB": 
            case "VARBINARY": 
            case "BINARY": {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        throw new TDengineConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("Doesn't support TDENGINE type '%s' yet.", tdengineType));
    }
}

