/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.tdengine.source;

import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.tdengine.config.TDengineSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.tdengine.exception.TDengineConnectorException;
import org.apache.seatunnel.connectors.seatunnel.tdengine.source.TDengineSourceSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDengineSourceReader
implements SourceReader<SeaTunnelRow, TDengineSourceSplit> {
    private static final Logger log = LoggerFactory.getLogger(TDengineSourceReader.class);
    private static final long THREAD_WAIT_TIME = 500L;
    private final TDengineSourceConfig config;
    private final Set<TDengineSourceSplit> sourceSplits;
    private final SourceReader.Context context;
    private Connection conn;

    public TDengineSourceReader(TDengineSourceConfig config, SourceReader.Context readerContext) {
        this.config = config;
        this.sourceSplits = Sets.newHashSet();
        this.context = readerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNext(Collector<SeaTunnelRow> collector) throws InterruptedException {
        if (this.sourceSplits.isEmpty()) {
            Thread.sleep(500L);
            return;
        }
        Object object = collector.getCheckpointLock();
        synchronized (object) {
            this.sourceSplits.forEach(split -> {
                try {
                    this.read((TDengineSourceSplit)split, collector);
                }
                catch (Exception e) {
                    throw new TDengineConnectorException((SeaTunnelErrorCode)CommonErrorCode.READER_OPERATION_FAILED, "TDengine split read error", e);
                }
            });
        }
        if (Boundedness.BOUNDED.equals((Object)this.context.getBoundedness())) {
            log.info("Closed the bounded TDengine source");
            this.context.signalNoMoreElement();
        }
    }

    public void open() {
        String jdbcUrl = StringUtils.join((Object[])new String[]{this.config.getUrl(), this.config.getDatabase(), "?user=", this.config.getUsername(), "&password=", this.config.getPassword()});
        Properties connProps = new Properties();
        connProps.setProperty("batchfetch", "false");
        try {
            this.conn = DriverManager.getConnection(jdbcUrl, connProps);
        }
        catch (SQLException e) {
            throw new TDengineConnectorException((SeaTunnelErrorCode)CommonErrorCode.READER_OPERATION_FAILED, "get TDengine connection failed:" + jdbcUrl);
        }
    }

    public void close() {
        try {
            if (!Objects.isNull(this.conn)) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new TDengineConnectorException((SeaTunnelErrorCode)CommonErrorCode.READER_OPERATION_FAILED, "TDengine reader connection close failed", e);
        }
    }

    private void read(TDengineSourceSplit split, Collector<SeaTunnelRow> output) throws Exception {
        try (Statement statement = this.conn.createStatement();){
            ResultSet resultSet = statement.executeQuery(split.getQuery());
            ResultSetMetaData meta = resultSet.getMetaData();
            while (resultSet.next()) {
                Object[] datas = new Object[meta.getColumnCount() + 1];
                datas[0] = split.splitId();
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    datas[i] = this.convertDataType(resultSet.getObject(i));
                }
                output.collect((Object)new SeaTunnelRow(datas));
            }
        }
    }

    private Object convertDataType(Object object) {
        if (Timestamp.class.equals(object.getClass())) {
            return ((Timestamp)object).toLocalDateTime();
        }
        if (byte[].class.equals(object.getClass())) {
            return new String((byte[])object);
        }
        return object;
    }

    public List<TDengineSourceSplit> snapshotState(long checkpointId) {
        return new ArrayList<TDengineSourceSplit>(this.sourceSplits);
    }

    public void addSplits(List<TDengineSourceSplit> splits) {
        this.sourceSplits.addAll(splits);
    }

    public void handleNoMoreSplits() {
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }
}

