/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.tdengine.source;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.tdengine.config.TDengineSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.tdengine.exception.TDengineConnectorException;
import org.apache.seatunnel.connectors.seatunnel.tdengine.source.StableMetadata;
import org.apache.seatunnel.connectors.seatunnel.tdengine.source.TDengineSourceReader;
import org.apache.seatunnel.connectors.seatunnel.tdengine.source.TDengineSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.tdengine.source.TDengineSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.tdengine.state.TDengineSourceState;
import org.apache.seatunnel.connectors.seatunnel.tdengine.typemapper.TDengineTypeMapper;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSource.class})
public class TDengineSource
implements SeaTunnelSource<SeaTunnelRow, TDengineSourceSplit, TDengineSourceState> {
    private StableMetadata stableMetadata;
    private TDengineSourceConfig tdengineSourceConfig;

    public String getPluginName() {
        return "TDengine";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        CheckResult result = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{TDengineSourceConfig.ConfigNames.URL, TDengineSourceConfig.ConfigNames.DATABASE, TDengineSourceConfig.ConfigNames.STABLE, TDengineSourceConfig.ConfigNames.USERNAME, TDengineSourceConfig.ConfigNames.PASSWORD});
        if (!result.isSuccess()) {
            throw new TDengineConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, "TDengine connection require url/database/stable/username/password. All of these must not be empty.");
        }
        this.tdengineSourceConfig = TDengineSourceConfig.buildSourceConfig(pluginConfig);
        this.stableMetadata = this.getStableMetadata(this.tdengineSourceConfig);
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.stableMetadata.getRowType();
    }

    public SourceReader<SeaTunnelRow, TDengineSourceSplit> createReader(SourceReader.Context readerContext) {
        return new TDengineSourceReader(this.tdengineSourceConfig, readerContext);
    }

    public SourceSplitEnumerator<TDengineSourceSplit, TDengineSourceState> createEnumerator(SourceSplitEnumerator.Context<TDengineSourceSplit> enumeratorContext) {
        return new TDengineSourceSplitEnumerator(this.stableMetadata, this.tdengineSourceConfig, enumeratorContext);
    }

    public SourceSplitEnumerator<TDengineSourceSplit, TDengineSourceState> restoreEnumerator(SourceSplitEnumerator.Context<TDengineSourceSplit> enumeratorContext, TDengineSourceState checkpointState) {
        return new TDengineSourceSplitEnumerator(this.stableMetadata, this.tdengineSourceConfig, checkpointState, enumeratorContext);
    }

    private StableMetadata getStableMetadata(TDengineSourceConfig config) throws SQLException {
        String timestampFieldName = null;
        ArrayList<String> subTableNames = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList fieldTypes = new ArrayList();
        String jdbcUrl = String.join((CharSequence)"", config.getUrl(), config.getDatabase(), "?user=", config.getUsername(), "&password=", config.getPassword());
        try (Connection conn = DriverManager.getConnection(jdbcUrl);){
            try (Statement statement = conn.createStatement();){
                ResultSet metaResultSet = statement.executeQuery("desc " + config.getDatabase() + "." + config.getStable());
                while (metaResultSet.next()) {
                    if (timestampFieldName == null) {
                        timestampFieldName = metaResultSet.getString(1);
                    }
                    fieldNames.add(metaResultSet.getString(1));
                    fieldTypes.add(TDengineTypeMapper.mapping(metaResultSet.getString(2)));
                }
            }
            statement = conn.createStatement();
            var10_12 = null;
            try {
                String metaSQL = "select table_name from information_schema.ins_tables where db_name = '" + config.getDatabase() + "' and stable_name='" + config.getStable() + "';";
                ResultSet subTableNameResultSet = statement.executeQuery(metaSQL);
                while (subTableNameResultSet.next()) {
                    String subTableName = subTableNameResultSet.getString(1);
                    subTableNames.add(subTableName);
                }
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (var10_12 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            var10_12.addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        SeaTunnelRowType rowType = this.addHiddenAttribute(fieldNames, fieldTypes);
        return new StableMetadata(rowType, timestampFieldName, subTableNames);
    }

    private SeaTunnelRowType addHiddenAttribute(List<String> fieldNames, List<SeaTunnelDataType<?>> fieldTypes) {
        String[] newFieldNames = (String[])ArrayUtils.add((Object[])fieldNames.toArray(new String[0]), (int)0, (Object)"subtable_name");
        SeaTunnelDataType[] newFieldTypes = (SeaTunnelDataType[])ArrayUtils.add((Object[])fieldTypes.toArray(new SeaTunnelDataType[0]), (int)0, (Object)BasicType.STRING_TYPE);
        return new SeaTunnelRowType(newFieldNames, newFieldTypes);
    }
}

