/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.utils.UnsignedDataUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class TSDBResultSetBlockData {
    private int numOfRows = 0;
    private int rowIndex = 0;
    private List<ColumnMetaData> columnMetaDataList;
    private ArrayList<List<Object>> colData;
    protected boolean wasNull;
    private int timestampPrecision;

    public TSDBResultSetBlockData(List<ColumnMetaData> colMeta, int numOfCols, int timestampPrecision) {
        this.columnMetaDataList = colMeta;
        this.colData = new ArrayList(numOfCols);
        this.timestampPrecision = timestampPrecision;
    }

    public TSDBResultSetBlockData(List<ColumnMetaData> colMeta, int timestampPrecision) {
        this.columnMetaDataList = colMeta;
        this.colData = new ArrayList();
        this.timestampPrecision = timestampPrecision;
    }

    public TSDBResultSetBlockData() {
        this.colData = new ArrayList();
    }

    public void clear() {
        int size = this.colData.size();
        this.colData.clear();
        this.setNumOfCols(size);
    }

    public int getNumOfRows() {
        return this.numOfRows;
    }

    public void setNumOfRows(int numOfRows) {
        this.numOfRows = numOfRows;
    }

    public int getNumOfCols() {
        return this.colData.size();
    }

    public void setNumOfCols(int numOfCols) {
        this.colData = new ArrayList(numOfCols);
    }

    public boolean hasMore() {
        return this.rowIndex < this.numOfRows;
    }

    public boolean forward() {
        if (this.rowIndex > this.numOfRows) {
            return false;
        }
        return ++this.rowIndex < this.numOfRows;
    }

    public void reset() {
        this.rowIndex = 0;
    }

    public void setByteArray(byte[] value) {
        ByteBuffer buffer = ByteBuffer.wrap(value);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int bitMapOffset = this.BitmapLen(this.numOfRows);
        int pHeader = 28 + this.columnMetaDataList.size() * 9;
        buffer.position(pHeader);
        for (int i = 0; i < this.columnMetaDataList.size(); ++i) {
            ArrayList<Object> col = new ArrayList<Object>(this.numOfRows);
            int type = this.columnMetaDataList.get(i).getColType();
            switch (type) {
                case 1: 
                case 2: 
                case 11: {
                    int j;
                    byte[] tmp = new byte[bitMapOffset];
                    buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        byte b = buffer.get();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(b);
                    }
                    break;
                }
                case 3: 
                case 12: {
                    int j;
                    byte[] tmp = new byte[bitMapOffset];
                    buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        short s2 = buffer.getShort();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(s2);
                    }
                    break;
                }
                case 4: 
                case 13: {
                    int j;
                    byte[] tmp = new byte[bitMapOffset];
                    buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        int in = buffer.getInt();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(in);
                    }
                    break;
                }
                case 5: 
                case 9: 
                case 14: {
                    int j;
                    byte[] tmp = new byte[bitMapOffset];
                    buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        long l = buffer.getLong();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(l);
                    }
                    break;
                }
                case 6: {
                    int j;
                    byte[] tmp = new byte[bitMapOffset];
                    buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        float f = buffer.getFloat();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(Float.valueOf(f));
                    }
                    break;
                }
                case 7: {
                    int j;
                    byte[] tmp = new byte[bitMapOffset];
                    buffer.get(tmp);
                    for (j = 0; j < this.numOfRows; ++j) {
                        double d = buffer.getDouble();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(d);
                    }
                    break;
                }
                case 8: 
                case 15: {
                    Object[] tmp;
                    int len;
                    int m3;
                    int m4;
                    ArrayList<Integer> offset = new ArrayList<Integer>(this.numOfRows);
                    for (m4 = 0; m4 < this.numOfRows; ++m4) {
                        offset.add(buffer.getInt());
                    }
                    int start = buffer.position();
                    for (m3 = 0; m3 < this.numOfRows; ++m3) {
                        if (-1 == (Integer)offset.get(m3)) {
                            col.add(null);
                            continue;
                        }
                        buffer.position(start + (Integer)offset.get(m3));
                        len = buffer.getShort();
                        tmp = new byte[len];
                        buffer.get((byte[])tmp);
                        col.add(tmp);
                    }
                    break;
                }
                case 10: {
                    Object[] tmp;
                    int len;
                    int m3;
                    int m4;
                    ArrayList<Integer> offset = new ArrayList(this.numOfRows);
                    for (m4 = 0; m4 < this.numOfRows; ++m4) {
                        offset.add(buffer.getInt());
                    }
                    int start = buffer.position();
                    for (m3 = 0; m3 < this.numOfRows; ++m3) {
                        if (-1 == (Integer)offset.get(m3)) {
                            col.add(null);
                            continue;
                        }
                        buffer.position(start + (Integer)offset.get(m3));
                        len = buffer.getShort() / 4;
                        tmp = new int[len];
                        for (int n = 0; n < len; ++n) {
                            tmp[n] = buffer.getInt();
                        }
                        col.add(new String((int[])tmp, 0, tmp.length));
                    }
                    break;
                }
                default: {
                    col.add(null);
                }
            }
            this.colData.add(col);
        }
    }

    public String getString(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            String charset = TaosGlobalConfig.getCharset();
            try {
                return new String((byte[])obj, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return obj.toString();
    }

    public byte[] getBytes(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes();
        }
        if (obj instanceof Long) {
            return Longs.toByteArray((Long)obj);
        }
        if (obj instanceof Integer) {
            return Ints.toByteArray((Integer)obj);
        }
        if (obj instanceof Short) {
            return Shorts.toByteArray((Short)obj);
        }
        if (obj instanceof Byte) {
            return new byte[]{(Byte)obj};
        }
        return obj.toString().getBytes();
    }

    public int getInt(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        int type = this.columnMetaDataList.get(col).getColType();
        switch (type) {
            case 1: {
                return (Boolean)obj != false ? 1 : 0;
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: 
            case 11: {
                return ((Short)obj).shortValue();
            }
            case 4: 
            case 12: {
                return (Integer)obj;
            }
            case 5: 
            case 13: {
                return ((Long)obj).intValue();
            }
            case 14: {
                BigDecimal tmp = (BigDecimal)obj;
                if (tmp.compareTo(new BigDecimal(Integer.MIN_VALUE)) < 0 || tmp.compareTo(new BigDecimal(Integer.MAX_VALUE)) > 0) {
                    this.throwRangeException(obj.toString(), col, 4);
                }
                return tmp.intValue();
            }
            case 9: {
                return Long.valueOf(((Timestamp)obj).getTime()).intValue();
            }
            case 6: 
            case 7: {
                return ((Double)obj).intValue();
            }
            case 10: {
                return Integer.parseInt((String)obj);
            }
            case 8: 
            case 15: {
                String charset = TaosGlobalConfig.getCharset();
                try {
                    return Integer.parseInt(new String((byte[])obj, charset));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        return 0;
    }

    public boolean getBoolean(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return Boolean.FALSE;
        }
        this.wasNull = false;
        int type = this.columnMetaDataList.get(col).getColType();
        switch (type) {
            case 1: {
                return (Boolean)obj;
            }
            case 2: {
                return (Byte)obj == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 3: 
            case 11: {
                return (Short)obj == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 4: 
            case 12: {
                return (Integer)obj == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 5: 
            case 13: {
                return (Long)obj == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            case 9: {
                return ((Timestamp)obj).getTime() == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            case 14: {
                return obj.equals(new BigDecimal(0)) ? Boolean.FALSE : Boolean.TRUE;
            }
            case 6: {
                return ((Float)obj).floatValue() == 0.0f ? Boolean.FALSE : Boolean.TRUE;
            }
            case 7: {
                return (Double)obj == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 10: {
                if ("TRUE".compareToIgnoreCase((String)obj) == 0) {
                    return Boolean.TRUE;
                }
                if ("FALSE".compareToIgnoreCase((String)obj) == 0) {
                    return Boolean.FALSE;
                }
                throw new SQLDataException();
            }
            case 8: 
            case 15: {
                String charset = TaosGlobalConfig.getCharset();
                try {
                    String tmp = new String((byte[])obj, charset);
                    return "TRUE".compareToIgnoreCase(tmp) == 0;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        return Boolean.FALSE;
    }

    public long getLong(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return 0L;
        }
        this.wasNull = false;
        int type = this.columnMetaDataList.get(col).getColType();
        switch (type) {
            case 1: {
                return (Boolean)obj != false ? 1L : 0L;
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: 
            case 11: {
                return ((Short)obj).shortValue();
            }
            case 4: 
            case 12: {
                return ((Integer)obj).intValue();
            }
            case 5: 
            case 13: {
                return (Long)obj;
            }
            case 14: {
                BigDecimal tmp = (BigDecimal)obj;
                if (tmp.compareTo(new BigDecimal(Long.MIN_VALUE)) < 0 || tmp.compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
                    this.throwRangeException(obj.toString(), col, -5);
                }
                return tmp.longValue();
            }
            case 9: {
                Timestamp ts = (Timestamp)obj;
                switch (this.timestampPrecision) {
                    default: {
                        return ts.getTime();
                    }
                    case 1: {
                        return ts.getTime() * 1000L + (long)(ts.getNanos() / 1000 % 1000);
                    }
                    case 2: 
                }
                return ts.getTime() * 1000000L + (long)(ts.getNanos() % 1000000);
            }
            case 6: {
                float tmp = ((Float)obj).floatValue();
                if (tmp < -9.223372E18f || tmp > 9.223372E18f) {
                    this.throwRangeException(obj.toString(), col, -5);
                }
                return (long)tmp;
            }
            case 7: {
                double tmp = (Double)obj;
                if (tmp < -9.223372036854776E18 || tmp > 9.223372036854776E18) {
                    this.throwRangeException(obj.toString(), col, -5);
                }
                return (long)tmp;
            }
            case 10: {
                return Long.parseLong((String)obj);
            }
            case 8: 
            case 15: {
                String charset = TaosGlobalConfig.getCharset();
                try {
                    return Long.parseLong(new String((byte[])obj, charset));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        return 0L;
    }

    private void throwRangeException(String valueAsString, int columnIndex, int jdbcType) throws SQLException {
        throw TSDBError.createSQLException(8980, "'" + valueAsString + "' in column '" + columnIndex + "' is outside valid range for the jdbcType " + TSDBConstants.jdbcType2TaosTypeName(jdbcType));
    }

    public Timestamp getTimestamp(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        int type = this.columnMetaDataList.get(col).getColType();
        if (type == 5) {
            return this.parseTimestampColumnData((Long)obj);
        }
        if (type == 9) {
            return (Timestamp)obj;
        }
        return new Timestamp(this.getLong(col));
    }

    public double getDouble(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            this.wasNull = true;
            return 0.0;
        }
        this.wasNull = false;
        int type = this.columnMetaDataList.get(col).getColType();
        switch (type) {
            case 1: {
                return (Boolean)obj != false ? 1.0 : 0.0;
            }
            case 2: {
                return ((Byte)obj).byteValue();
            }
            case 3: 
            case 11: {
                return ((Short)obj).shortValue();
            }
            case 4: 
            case 12: {
                return ((Integer)obj).intValue();
            }
            case 5: 
            case 13: {
                return ((Long)obj).longValue();
            }
            case 14: {
                BigDecimal tmp = (BigDecimal)obj;
                if (tmp.compareTo(new BigDecimal(Double.MIN_VALUE)) < 0 || tmp.compareTo(new BigDecimal(Double.MAX_VALUE)) > 0) {
                    this.throwRangeException(obj.toString(), col, 93);
                }
                return tmp.floatValue();
            }
            case 9: {
                Timestamp ts = (Timestamp)obj;
                switch (this.timestampPrecision) {
                    default: {
                        return ts.getTime();
                    }
                    case 1: {
                        return ts.getTime() * 1000L + (long)(ts.getNanos() / 1000 % 1000);
                    }
                    case 2: 
                }
                return ts.getTime() * 1000000L + (long)(ts.getNanos() % 1000000);
            }
            case 6: {
                return Double.parseDouble(String.valueOf(obj));
            }
            case 7: {
                return (Double)obj;
            }
            case 10: {
                return Double.parseDouble((String)obj);
            }
            case 8: 
            case 15: {
                String charset = TaosGlobalConfig.getCharset();
                try {
                    return Double.parseDouble(new String((byte[])obj, charset));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        return 0.0;
    }

    public Object get(int col) {
        List<Object> bb = this.colData.get(col);
        Object source = bb.get(this.rowIndex);
        if (null == source) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        switch (this.columnMetaDataList.get(col).getColType()) {
            case 1: {
                byte val = (Byte)source;
                return val == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: {
                return source;
            }
            case 11: {
                byte val = (Byte)source;
                return UnsignedDataUtils.parseUTinyInt(val);
            }
            case 12: {
                short val = (Short)source;
                return UnsignedDataUtils.parseUSmallInt(val);
            }
            case 13: {
                int val = (Integer)source;
                return UnsignedDataUtils.parseUInteger(val);
            }
            case 9: {
                long val = (Long)source;
                return this.parseTimestampColumnData(val);
            }
            case 14: {
                long val = (Long)source;
                return UnsignedDataUtils.parseUBigInt(val);
            }
        }
        return null;
    }

    private Timestamp parseTimestampColumnData(long value) {
        if (0 == this.timestampPrecision) {
            return new Timestamp(value);
        }
        if (1 == this.timestampPrecision) {
            long epochSec = value / 1000000L;
            long nanoAdjustment = value % 1000000L * 1000L;
            return Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
        }
        if (2 == this.timestampPrecision) {
            long epochSec = value / 1000000000L;
            long nanoAdjustment = value % 1000000000L;
            return Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
        }
        return null;
    }

    private int BitmapLen(int n) {
        return n + 7 >> 3;
    }

    private boolean isNull(byte[] c, int n) {
        int position = n >>> 3;
        int index = n & 7;
        return (c[position] & 1 << 7 - index) == 1 << 7 - index;
    }
}

