/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.serialize;

import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.starrocks.serialize.StarRocksBaseSerializer;
import org.apache.seatunnel.connectors.seatunnel.starrocks.serialize.StarRocksDelimiterParser;
import org.apache.seatunnel.connectors.seatunnel.starrocks.serialize.StarRocksISerializer;
import org.apache.seatunnel.connectors.seatunnel.starrocks.serialize.StarRocksSinkOP;

public class StarRocksCsvSerializer
extends StarRocksBaseSerializer
implements StarRocksISerializer {
    private static final long serialVersionUID = 1L;
    private final String columnSeparator;
    private final SeaTunnelRowType seaTunnelRowType;
    private final boolean enableUpsertDelete;

    public StarRocksCsvSerializer(String sp, SeaTunnelRowType seaTunnelRowType, boolean enableUpsertDelete) {
        this.columnSeparator = StarRocksDelimiterParser.parse(sp, "\t");
        this.seaTunnelRowType = seaTunnelRowType;
        this.enableUpsertDelete = enableUpsertDelete;
    }

    @Override
    public String serialize(SeaTunnelRow row) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < row.getFields().length; ++i) {
            Object value = this.convert(this.seaTunnelRowType.getFieldType(i), row.getField(i));
            sb.append(null == value ? "\\N" : value);
            if (i >= row.getFields().length - 1) continue;
            sb.append(this.columnSeparator);
        }
        if (this.enableUpsertDelete) {
            sb.append(this.columnSeparator).append(StarRocksSinkOP.parse(row.getRowKind()).ordinal());
        }
        return sb.toString();
    }
}

