/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.datatypes;

import com.google.auto.service.AutoService;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalArrayType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.starrocks.datatypes.StarRocksType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class StarRocksTypeConverter
implements TypeConverter<BasicTypeDefine<StarRocksType>> {
    private static final Logger log = LoggerFactory.getLogger(StarRocksTypeConverter.class);
    public static final long MAX_STRING_LENGTH = 0x7FFFFFFBL;
    public static final Long MAX_PRECISION = 38L;
    public static final Integer MAX_SCALE = 10;
    public static final Integer MAX_DATETIME_SCALE = 6;
    public static final long POWER_2_8 = (long)Math.pow(2.0, 8.0);
    public static final StarRocksTypeConverter INSTANCE = new StarRocksTypeConverter();

    public String identifier() {
        return "StarRocks";
    }

    public Column convert(BasicTypeDefine<StarRocksType> typeDefine) {
        String type;
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        switch (type = this.getOriginalType(typeDefine)) {
            case "NULL": {
                builder.dataType((SeaTunnelDataType)BasicType.VOID_TYPE);
                break;
            }
            case "BOOLEAN": {
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "TINYINT": {
                if ("TINYINT(1)".equalsIgnoreCase(typeDefine.getColumnType())) {
                    builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                    break;
                }
                builder.dataType((SeaTunnelDataType)BasicType.BYTE_TYPE);
                break;
            }
            case "SMALLINT": {
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "INT": {
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "BIGINT": {
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "LARGEINT": {
                DecimalType decimalType = new DecimalType(20, 0);
                builder.dataType((SeaTunnelDataType)decimalType);
                builder.columnLength(Long.valueOf(20L));
                builder.scale(Integer.valueOf(0));
                break;
            }
            case "FLOAT": {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "DOUBLE": {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "DECIMAL": 
            case "DECIMALV3": {
                this.setDecimalType(builder, typeDefine);
                break;
            }
            case "CHAR": 
            case "VARCHAR": {
                if (typeDefine.getLength() != null && typeDefine.getLength() > 0L) {
                    builder.columnLength(typeDefine.getLength());
                }
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "STRING": 
            case "JSON": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(0x7FFFFFFBL));
                break;
            }
            case "DATE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case "DATETIME": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(Integer.valueOf(typeDefine.getScale() == null ? 0 : typeDefine.getScale()));
                break;
            }
            case "ARRAY": {
                this.convertArray(typeDefine.getColumnType(), builder, typeDefine.getName());
                break;
            }
            case "MAP": {
                this.convertMap(typeDefine.getColumnType(), builder, typeDefine.getName());
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)this.identifier(), (String)typeDefine.getColumnType(), (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine<StarRocksType> reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case NULL: {
                builder.columnType("NULL");
                builder.dataType("NULL");
                break;
            }
            case BYTES: {
                builder.columnType("STRING");
                builder.dataType("STRING");
                break;
            }
            case BOOLEAN: {
                builder.columnType("BOOLEAN");
                builder.dataType("BOOLEAN");
                builder.length(Long.valueOf(1L));
                break;
            }
            case TINYINT: {
                builder.columnType("TINYINT");
                builder.dataType("TINYINT");
                break;
            }
            case SMALLINT: {
                builder.columnType("SMALLINT");
                builder.dataType("SMALLINT");
                break;
            }
            case INT: {
                builder.columnType("INT");
                builder.dataType("INT");
                break;
            }
            case BIGINT: {
                builder.columnType("BIGINT");
                builder.dataType("BIGINT");
                break;
            }
            case FLOAT: {
                builder.columnType("FLOAT");
                builder.dataType("FLOAT");
                break;
            }
            case DOUBLE: {
                builder.columnType("DOUBLE");
                builder.dataType("DOUBLE");
                break;
            }
            case DECIMAL: {
                if (column.getSourceType() != null && column.getSourceType().equalsIgnoreCase("LARGEINT")) {
                    builder.dataType("LARGEINT");
                    builder.columnType("LARGEINT");
                    break;
                }
                DecimalType decimalType = (DecimalType)column.getDataType();
                int precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0) {
                    precision = MAX_PRECISION.intValue();
                    scale = MAX_SCALE;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if ((long)precision > MAX_PRECISION) {
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to varchar(200)", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), MAX_PRECISION});
                    builder.dataType("VARCHAR");
                    builder.columnType(String.format("%s(%s)", "VARCHAR", 200));
                    break;
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > precision) {
                    scale = precision;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, precision, scale});
                }
                builder.columnType(String.format("%s(%s,%s)", "DECIMALV3", precision, scale));
                builder.dataType("DECIMALV3");
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case TIME: {
                builder.length(Long.valueOf(8L));
                builder.columnType(String.format("%s(%s)", "VARCHAR", 8));
                builder.dataType("VARCHAR");
                break;
            }
            case ARRAY: {
                SeaTunnelDataType dataType = column.getDataType();
                SeaTunnelDataType elementType = null;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    elementType = arrayType.getElementType();
                }
                this.reconvertBuildArrayInternal(elementType, (BasicTypeDefine.BasicTypeDefineBuilder<StarRocksType>)builder, column.getName());
                break;
            }
            case ROW: {
                builder.columnType("JSON");
                builder.dataType("JSON");
                break;
            }
            case STRING: {
                this.reconvertString(column, (BasicTypeDefine.BasicTypeDefineBuilder<StarRocksType>)builder);
                break;
            }
            case DATE: {
                builder.columnType("DATE");
                builder.dataType("DATE");
                break;
            }
            case TIMESTAMP: {
                builder.columnType("DATETIME");
                builder.dataType("DATETIME");
                break;
            }
            case MAP: {
                this.reconvertMap(column, (BasicTypeDefine.BasicTypeDefineBuilder<StarRocksType>)builder);
                break;
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)this.identifier(), (String)column.getDataType().getSqlType().name(), (String)column.getName());
            }
        }
        return builder.build();
    }

    private void setDecimalType(PhysicalColumn.PhysicalColumnBuilder builder, BasicTypeDefine<StarRocksType> typeDefine) {
        Long p = 10L;
        int scale = 0;
        if (typeDefine.getPrecision() != null && typeDefine.getPrecision() > 0L) {
            p = typeDefine.getPrecision();
        }
        if (typeDefine.getScale() != null && typeDefine.getScale() > 0) {
            scale = typeDefine.getScale();
        }
        DecimalType decimalType = new DecimalType(p.intValue(), scale);
        builder.dataType((SeaTunnelDataType)decimalType);
        builder.columnLength(p);
        builder.scale(Integer.valueOf(scale));
    }

    private void convertArray(String columnType, PhysicalColumn.PhysicalColumnBuilder builder, String name) {
        String columnInterType = StarRocksTypeConverter.extractArrayType(columnType);
        if (columnInterType.equalsIgnoreCase("tinyint(1)")) {
            builder.dataType((SeaTunnelDataType)ArrayType.BOOLEAN_ARRAY_TYPE);
        } else if (columnInterType.equalsIgnoreCase("tinyint(4)")) {
            builder.dataType((SeaTunnelDataType)ArrayType.BYTE_ARRAY_TYPE);
        } else if (columnInterType.equalsIgnoreCase("smallint(6)")) {
            builder.dataType((SeaTunnelDataType)ArrayType.SHORT_ARRAY_TYPE);
        } else if (columnInterType.equalsIgnoreCase("int(11)")) {
            builder.dataType((SeaTunnelDataType)ArrayType.INT_ARRAY_TYPE);
        } else if (columnInterType.equalsIgnoreCase("bigint(20)")) {
            builder.dataType((SeaTunnelDataType)ArrayType.LONG_ARRAY_TYPE);
        } else if (columnInterType.equalsIgnoreCase("FLOAT")) {
            builder.dataType((SeaTunnelDataType)ArrayType.FLOAT_ARRAY_TYPE);
        } else if (columnInterType.equalsIgnoreCase("DOUBLE")) {
            builder.dataType((SeaTunnelDataType)ArrayType.DOUBLE_ARRAY_TYPE);
        } else if (columnInterType.toUpperCase(Locale.ROOT).startsWith("CHAR") || columnInterType.toUpperCase(Locale.ROOT).startsWith("VARCHAR") || columnInterType.equalsIgnoreCase("STRING")) {
            builder.dataType((SeaTunnelDataType)ArrayType.STRING_ARRAY_TYPE);
        } else if (columnInterType.toUpperCase(Locale.ROOT).startsWith("DECIMAL")) {
            int[] precisionAndScale = StarRocksTypeConverter.getPrecisionAndScale(columnInterType);
            DecimalArrayType decimalArray = new DecimalArrayType(new DecimalType(precisionAndScale[0], precisionAndScale[1]));
            builder.dataType((SeaTunnelDataType)decimalArray);
        } else if (columnInterType.equalsIgnoreCase("date") || columnInterType.equalsIgnoreCase("DATEV2")) {
            builder.dataType((SeaTunnelDataType)ArrayType.LOCAL_DATE_ARRAY_TYPE);
        } else if (columnInterType.equalsIgnoreCase("DATETIME") || columnInterType.equalsIgnoreCase("DATETIMEV2")) {
            builder.dataType((SeaTunnelDataType)ArrayType.LOCAL_DATE_TIME_ARRAY_TYPE);
        } else if (columnInterType.equalsIgnoreCase("LARGEINT")) {
            DecimalArrayType decimalArray = new DecimalArrayType(new DecimalType(20, 0));
            builder.dataType((SeaTunnelDataType)decimalArray);
        } else {
            throw CommonError.convertToSeaTunnelTypeError((String)this.identifier(), (String)columnType, (String)name);
        }
    }

    private static String extractArrayType(String input) {
        Pattern pattern = Pattern.compile("<(.*?)>");
        Matcher matcher = pattern.matcher(input);
        return matcher.find() ? matcher.group(1) : "";
    }

    private void convertMap(String columnType, PhysicalColumn.PhysicalColumnBuilder builder, String name) {
        String[] keyValueType = Optional.ofNullable(StarRocksTypeConverter.extractMapKeyValueType(columnType)).orElseThrow(() -> new IllegalArgumentException("Invalid map type: " + columnType));
        MapType mapType = new MapType(this.turnColumnTypeToSeaTunnelType(keyValueType[0], name + ".key"), this.turnColumnTypeToSeaTunnelType(keyValueType[1], name + ".value"));
        builder.dataType((SeaTunnelDataType)mapType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] extractMapKeyValueType(String input) {
        String[] result = new String[2];
        String[] split = (input = input.replaceAll("map<", "").replaceAll("MAP<", "").replaceAll(">", "")).split(",");
        if (split.length == 4) {
            result[0] = split[0] + "," + split[1];
            result[1] = split[2] + "," + split[3];
            return result;
        } else if (split.length == 3) {
            if (split[0].contains("(") && split[1].contains(")")) {
                result[0] = split[0] + "," + split[1];
                result[1] = split[2];
                return result;
            } else {
                if (!split[1].contains("(") || !split[2].contains(")")) return null;
                result[0] = split[0];
                result[1] = split[1] + "," + split[2];
            }
            return result;
        } else {
            if (split.length != 2) return null;
            result[0] = split[0];
            result[1] = split[1];
        }
        return result;
    }

    private SeaTunnelDataType turnColumnTypeToSeaTunnelType(String columnType, String columnName) {
        BasicTypeDefine keyBasicTypeDefine = BasicTypeDefine.builder().columnType(columnType).name(columnName).build();
        if (columnType.toUpperCase(Locale.ROOT).startsWith("DECIMAL")) {
            int[] precisionAndScale = StarRocksTypeConverter.getPrecisionAndScale(columnType);
            keyBasicTypeDefine.setPrecision(Long.valueOf(precisionAndScale[0]));
            keyBasicTypeDefine.setScale(Integer.valueOf(precisionAndScale[1]));
        }
        Column column = this.convert((BasicTypeDefine<StarRocksType>)keyBasicTypeDefine);
        return column.getDataType();
    }

    private String getOriginalType(BasicTypeDefine<StarRocksType> typeDefine) {
        String columnType = typeDefine.getColumnType().toUpperCase(Locale.ROOT);
        if (StringUtils.isBlank(columnType)) {
            throw new IllegalArgumentException("Column type is empty.");
        }
        if (columnType.contains("<") && columnType.contains(">")) {
            return columnType.substring(0, columnType.indexOf("<"));
        }
        if (columnType.contains("(") && columnType.contains(")")) {
            return columnType.substring(0, columnType.indexOf("("));
        }
        return columnType;
    }

    private static int[] getPrecisionAndScale(String decimalTypeDefinition) {
        decimalTypeDefinition = decimalTypeDefinition.toUpperCase(Locale.ROOT);
        String numericPart = decimalTypeDefinition.replace("DECIMALV3(", "").replace(")", "");
        String[] parts = (numericPart = numericPart.replace("DECIMAL(", "").replace(")", "")).split(",");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid DECIMAL definition: " + decimalTypeDefinition);
        }
        int precision = Integer.parseInt(parts[0].trim());
        int scale = Integer.parseInt(parts[1].trim());
        return new int[]{precision, scale};
    }

    private void reconvertBuildArrayInternal(SeaTunnelDataType elementType, BasicTypeDefine.BasicTypeDefineBuilder<StarRocksType> builder, String columnName) {
        switch (elementType.getSqlType()) {
            case BOOLEAN: {
                builder.columnType("ARRAY<boolean>");
                builder.dataType("ARRAY<boolean>");
                break;
            }
            case TINYINT: {
                builder.columnType("ARRAY<tinyint>");
                builder.dataType("ARRAY<tinyint>");
                break;
            }
            case SMALLINT: {
                builder.columnType("ARRAY<smallint>");
                builder.dataType("ARRAY<smallint>");
                break;
            }
            case INT: {
                builder.columnType("ARRAY<int(11)>");
                builder.dataType("ARRAY<int(11)>");
                break;
            }
            case BIGINT: {
                builder.columnType("ARRAY<bigint>");
                builder.dataType("ARRAY<bigint>");
                break;
            }
            case FLOAT: {
                builder.columnType("ARRAY<float>");
                builder.dataType("ARRAY<float>");
                break;
            }
            case DOUBLE: {
                builder.columnType("ARRAY<double>");
                builder.dataType("ARRAY<double>");
                break;
            }
            case DECIMAL: {
                int[] precisionAndScale = StarRocksTypeConverter.getPrecisionAndScale(elementType.toString());
                builder.columnType(String.format("ARRAY<DECIMALV3(%s, %s)>", precisionAndScale[0], precisionAndScale[1]));
                builder.dataType("ARRAY<DECIMALV3>");
                break;
            }
            case TIME: 
            case STRING: {
                builder.columnType("ARRAY<STRING>");
                builder.dataType("ARRAY<STRING>");
                break;
            }
            case DATE: {
                builder.columnType("ARRAY<DATEV2>");
                builder.dataType("ARRAY<DATEV2>");
                break;
            }
            case TIMESTAMP: {
                builder.columnType("ARRAY<DATETIMEV2>");
                builder.dataType("ARRAY<DATETIMEV2>");
                break;
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)this.identifier(), (String)elementType.getSqlType().name(), (String)columnName);
            }
        }
    }

    private void reconvertString(Column column, BasicTypeDefine.BasicTypeDefineBuilder<StarRocksType> builder) {
        if (column.getSourceType() != null && column.getSourceType().equalsIgnoreCase("JSON")) {
            builder.columnType("JSON");
            builder.dataType("JSON");
            return;
        }
        this.sampleReconvertString(column, builder);
    }

    protected void sampleReconvertString(Column column, BasicTypeDefine.BasicTypeDefineBuilder<StarRocksType> builder) {
        if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
            builder.columnType("STRING");
            builder.dataType("STRING");
            return;
        }
        if (column.getColumnLength() < POWER_2_8) {
            if (column.getSourceType() != null && column.getSourceType().toUpperCase(Locale.ROOT).startsWith("VARCHAR")) {
                builder.columnType(String.format("%s(%s)", "VARCHAR", column.getColumnLength()));
                builder.dataType("VARCHAR");
            } else {
                builder.columnType(String.format("%s(%s)", "CHAR", column.getColumnLength()));
                builder.dataType("CHAR");
            }
            return;
        }
        if (column.getColumnLength() <= 65533L) {
            builder.columnType(String.format("%s(%s)", "VARCHAR", column.getColumnLength()));
            builder.dataType("VARCHAR");
            return;
        }
        if (column.getColumnLength() <= 0x7FFFFFFBL) {
            builder.columnType("STRING");
            builder.dataType("STRING");
            return;
        }
        log.warn(String.format("The String type in StarRocks can only store up to 2GB bytes, and the current field [%s] length is [%s] bytes. If it is greater than the maximum length of the String in Doris, it may not be able to write data", column.getName(), column.getColumnLength()));
        builder.columnType("STRING");
        builder.dataType("STRING");
    }

    private void reconvertMap(Column column, BasicTypeDefine.BasicTypeDefineBuilder<StarRocksType> builder) {
        MapType dataType = (MapType)column.getDataType();
        SeaTunnelDataType keyType = dataType.getKeyType();
        SeaTunnelDataType valueType = dataType.getValueType();
        PhysicalColumn keyColumn = PhysicalColumn.of((String)(column.getName() + ".key"), (SeaTunnelDataType)keyType, (Long)null, (boolean)true, null, null);
        String keyColumnType = this.reconvert((Column)keyColumn).getColumnType();
        PhysicalColumn valueColumn = PhysicalColumn.of((String)(column.getName() + ".value"), (SeaTunnelDataType)valueType, (Long)null, (boolean)true, null, null);
        String valueColumnType = this.reconvert((Column)valueColumn).getColumnType();
        builder.dataType(String.format("MAP<%s, %s>", keyColumnType, valueColumnType));
        builder.columnType(String.format("MAP<%s, %s>", keyColumnType, valueColumnType));
    }
}

