/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.StarRocksConfig;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.StarRocksSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.StarRocksSourceTableConfig;

public class SourceConfig
extends StarRocksConfig {
    private int maxRetries = (Integer)StarRocksSourceOptions.MAX_RETRIES.defaultValue();
    private int requestTabletSize = (Integer)StarRocksSourceOptions.QUERY_TABLET_SIZE.defaultValue();
    private String scanFilter = (String)StarRocksSourceOptions.SCAN_FILTER.defaultValue();
    private long memLimit = (Long)StarRocksSourceOptions.SCAN_MEM_LIMIT.defaultValue();
    private int queryTimeoutSec = (Integer)StarRocksSourceOptions.SCAN_QUERY_TIMEOUT_SEC.defaultValue();
    private int keepAliveMin = (Integer)StarRocksSourceOptions.SCAN_KEEP_ALIVE_MIN.defaultValue();
    private int batchRows = (Integer)StarRocksSourceOptions.SCAN_BATCH_ROWS.defaultValue();
    private int connectTimeoutMs = (Integer)StarRocksSourceOptions.SCAN_CONNECT_TIMEOUT.defaultValue();
    private List<StarRocksSourceTableConfig> tableConfigList = new ArrayList<StarRocksSourceTableConfig>();
    private Map<String, String> sourceOptionProps = new HashMap<String, String>();

    public SourceConfig(ReadonlyConfig config) {
        super(config);
        this.maxRetries = (Integer)config.get(StarRocksSourceOptions.MAX_RETRIES);
        this.requestTabletSize = (Integer)config.get(StarRocksSourceOptions.QUERY_TABLET_SIZE);
        this.scanFilter = (String)config.get(StarRocksSourceOptions.SCAN_FILTER);
        this.connectTimeoutMs = (Integer)config.get(StarRocksSourceOptions.SCAN_CONNECT_TIMEOUT);
        this.batchRows = (Integer)config.get(StarRocksSourceOptions.SCAN_BATCH_ROWS);
        this.keepAliveMin = (Integer)config.get(StarRocksSourceOptions.SCAN_KEEP_ALIVE_MIN);
        this.queryTimeoutSec = (Integer)config.get(StarRocksSourceOptions.SCAN_QUERY_TIMEOUT_SEC);
        this.memLimit = (Long)config.get(StarRocksSourceOptions.SCAN_MEM_LIMIT);
        String prefix = StarRocksSourceOptions.STARROCKS_SCAN_CONFIG_PREFIX.key();
        config.toMap().forEach((key, value) -> {
            if (key.startsWith(prefix)) {
                this.sourceOptionProps.put(key.substring(prefix.length()).toLowerCase(), (String)value);
            }
        });
        this.tableConfigList = StarRocksSourceTableConfig.of(config);
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRequestTabletSize(int requestTabletSize) {
        this.requestTabletSize = requestTabletSize;
    }

    public void setScanFilter(String scanFilter) {
        this.scanFilter = scanFilter;
    }

    public void setMemLimit(long memLimit) {
        this.memLimit = memLimit;
    }

    public void setQueryTimeoutSec(int queryTimeoutSec) {
        this.queryTimeoutSec = queryTimeoutSec;
    }

    public void setKeepAliveMin(int keepAliveMin) {
        this.keepAliveMin = keepAliveMin;
    }

    public void setBatchRows(int batchRows) {
        this.batchRows = batchRows;
    }

    public void setConnectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public void setTableConfigList(List<StarRocksSourceTableConfig> tableConfigList) {
        this.tableConfigList = tableConfigList;
    }

    public void setSourceOptionProps(Map<String, String> sourceOptionProps) {
        this.sourceOptionProps = sourceOptionProps;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRequestTabletSize() {
        return this.requestTabletSize;
    }

    public String getScanFilter() {
        return this.scanFilter;
    }

    public long getMemLimit() {
        return this.memLimit;
    }

    public int getQueryTimeoutSec() {
        return this.queryTimeoutSec;
    }

    public int getKeepAliveMin() {
        return this.keepAliveMin;
    }

    public int getBatchRows() {
        return this.batchRows;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public List<StarRocksSourceTableConfig> getTableConfigList() {
        return this.tableConfigList;
    }

    public Map<String, String> getSourceOptionProps() {
        return this.sourceOptionProps;
    }
}

