/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.socket.config;

import java.io.Serializable;
import org.apache.seatunnel.connectors.seatunnel.socket.config.SocketSinkConfigOptions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class SinkConfig
implements Serializable {
    private String host;
    private int port;
    private int maxNumRetries;

    public SinkConfig(Config config) {
        this.host = config.getString(SocketSinkConfigOptions.HOST.key());
        this.port = config.getInt(SocketSinkConfigOptions.PORT.key());
        if (config.hasPath(SocketSinkConfigOptions.MAX_RETRIES.key())) {
            this.maxNumRetries = config.getInt(SocketSinkConfigOptions.MAX_RETRIES.key());
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getMaxNumRetries() {
        return this.maxNumRetries;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMaxNumRetries(int maxNumRetries) {
        this.maxNumRetries = maxNumRetries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinkConfig)) {
            return false;
        }
        SinkConfig other = (SinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getMaxNumRetries() != other.getMaxNumRetries()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getMaxNumRetries();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public String toString() {
        return "SinkConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", maxNumRetries=" + this.getMaxNumRetries() + ")";
    }
}

