/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.IndexKey;
import com.aliyun.openservices.log.common.IndexKeys;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class IndexJsonKey
extends IndexKey
implements Serializable {
    private boolean indexAll = true;
    private int maxDepth = -1;
    private IndexKeys jsonKeys = new IndexKeys();

    public IndexJsonKey() {
        this.SetType("json");
    }

    public IndexJsonKey(List<String> token, boolean caseSensitive) {
        super(token, caseSensitive);
        this.SetType("json");
    }

    public IndexJsonKey(List<String> token, boolean caseSensitive, String type) {
        super(token, caseSensitive, type);
        this.SetType("json");
    }

    public IndexJsonKey(List<String> token, boolean caseSensitive, String type, String alias) {
        super(token, caseSensitive, type, alias);
        this.SetType("json");
    }

    public IndexJsonKey(IndexJsonKey other) {
        super(other);
        this.SetType("json");
        this.setIndexAll(other.isIndexAll());
        this.setMaxDepth(other.getMaxDepth());
        this.setJsonKeys(new IndexKeys(other.getJsonKeys()));
    }

    public boolean isIndexAll() {
        return this.indexAll;
    }

    public void setIndexAll(boolean indexAll) {
        this.indexAll = indexAll;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public IndexKeys getJsonKeys() {
        return this.jsonKeys;
    }

    public void setJsonKeys(IndexKeys jsonKeys) {
        this.jsonKeys = jsonKeys;
    }

    @Override
    public void FromJsonObject(JSONObject dict) throws LogException {
        super.FromJsonObject(dict);
        if (dict.containsKey("index_all")) {
            this.setIndexAll(dict.getBooleanValue("index_all"));
        }
        if (dict.containsKey("max_depth")) {
            this.setMaxDepth(dict.getIntValue("max_depth"));
        }
        if (dict.containsKey("json_keys")) {
            JSONObject jsonObject = dict.getJSONObject("json_keys");
            this.jsonKeys.FromJsonObject(jsonObject);
        }
    }

    @Override
    public JSONObject ToRequestJson() throws LogException {
        JSONObject allKeys = super.ToRequestJson();
        JSONArray tokenDict = new JSONArray();
        tokenDict.addAll((Collection<?>)this.GetToken());
        if ("json".equals(this.GetType())) {
            allKeys.put("token", (Object)tokenDict);
            allKeys.put("caseSensitive", (Object)this.GetCaseSensitive());
            allKeys.put("chn", (Object)this.IsChn());
        }
        allKeys.put("index_all", (Object)this.isIndexAll());
        allKeys.put("max_depth", (Object)this.getMaxDepth());
        allKeys.put("json_keys", (Object)this.getJsonKeys().ToRequestJson());
        return allKeys;
    }
}

