/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.List;

public class ResourceRecord
implements Serializable {
    private static final long serialVersionUID = -1184418783117426648L;
    private String value = null;
    private String tag = null;
    private String id = null;
    private long createTime = 0L;
    private long lastModifyTime = 0L;

    public ResourceRecord() {
    }

    public ResourceRecord(String value) {
        this.value = value;
    }

    public ResourceRecord(String id, String value) {
        this.id = id;
        this.value = value;
    }

    public ResourceRecord(String id, String tag, String value) {
        this.id = id;
        this.tag = tag;
        this.value = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getLastModifyTime() {
        return this.lastModifyTime;
    }

    public JSONObject ToJsonObject() throws LogException {
        JSONObject result = new JSONObject();
        if (this.tag != null) {
            result.put("tag", (Object)this.tag);
        }
        if (this.id != null) {
            result.put("id", (Object)this.id);
        }
        result.put("value", (Object)this.getValue());
        return result;
    }

    public static String ToJsonString(List<ResourceRecord> records) throws LogException {
        JSONObject result = new JSONObject();
        JSONArray recordArray = new JSONArray();
        for (ResourceRecord r : records) {
            recordArray.add(r.ToJsonObject());
        }
        result.put("records", (Object)recordArray);
        return result.toString();
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        this.setValue(dict.getString("value"));
        if (dict.containsKey("tag")) {
            this.tag = dict.getString("tag");
        }
        if (dict.containsKey("id")) {
            this.id = dict.getString("id");
        }
        if (dict.containsKey("createTime")) {
            this.createTime = dict.getIntValue("createTime");
        }
        if (dict.containsKey("lastModifyTime")) {
            this.lastModifyTime = dict.getIntValue("lastModifyTime");
        }
        try {
            JSONObject.parseObject(dict.getString("value"));
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "response record value is not valid json", e, e.getMessage());
        }
    }

    public void FromJsonString(String content) throws LogException {
        JSONObject dict = JSONObject.parseObject(content);
        this.FromJsonObject(dict);
    }

    public void checkForCreate() throws IllegalArgumentException {
        this.checkForValue();
    }

    public void checkForUpdate() throws IllegalArgumentException {
        this.checkForValue();
        if (this.id == null || this.id.isEmpty()) {
            throw new IllegalArgumentException("id is null/empty");
        }
    }

    public void checkForUpsert() throws IllegalArgumentException {
        this.checkForCreate();
    }

    private void checkForValue() throws IllegalArgumentException {
        if (this.value == null || this.value.isEmpty()) {
            throw new IllegalArgumentException("value is null/empty");
        }
        try {
            JSONObject.parseObject(this.value);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("record value not valid json");
        }
    }
}

