/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryTraceHeader;
import io.sentry.SentryTracer;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.protocol.SentryId;
import io.sentry.util.Objects;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class Span
implements ISpan {
    @NotNull
    private final Date startTimestamp;
    @Nullable
    private Date timestamp;
    @NotNull
    private final SpanContext context;
    @NotNull
    private final SentryTracer transaction;
    @Nullable
    private Throwable throwable;
    @NotNull
    private final IHub hub;
    @NotNull
    private final AtomicBoolean finished = new AtomicBoolean(false);

    Span(@NotNull SentryId traceId, @Nullable SpanId parentSpanId, @NotNull SentryTracer transaction, @NotNull String operation, @NotNull IHub hub) {
        this.context = new SpanContext(traceId, new SpanId(), operation, parentSpanId, transaction.isSampled());
        this.transaction = Objects.requireNonNull(transaction, "transaction is required");
        this.startTimestamp = DateUtils.getCurrentDateTime();
        this.hub = Objects.requireNonNull(hub, "hub is required");
    }

    Span(@NotNull TransactionContext context, @NotNull SentryTracer sentryTracer, @NotNull IHub hub) {
        this.context = Objects.requireNonNull(context, "context is required");
        this.transaction = Objects.requireNonNull(sentryTracer, "sentryTracer is required");
        this.hub = Objects.requireNonNull(hub, "hub is required");
        this.startTimestamp = DateUtils.getCurrentDateTime();
    }

    @NotNull
    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nullable
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return this.startChild(operation, null);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description) {
        return this.transaction.startChild(this.context.getSpanId(), operation, description);
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return new SentryTraceHeader(this.context.getTraceId(), this.context.getSpanId(), this.context.getSampled());
    }

    @Override
    public void finish() {
        this.finish(this.context.getStatus());
    }

    @Override
    public void finish(@Nullable SpanStatus status) {
        if (!this.finished.compareAndSet(false, true)) {
            return;
        }
        this.context.setStatus(status);
        this.timestamp = DateUtils.getCurrentDateTime();
        if (this.throwable != null) {
            this.hub.setSpanContext(this.throwable, this, this.transaction.getName());
        }
    }

    @Override
    public void setOperation(@NotNull String operation) {
        this.context.setOperation(operation);
    }

    @Override
    @NotNull
    public String getOperation() {
        return this.context.getOperation();
    }

    @Override
    public void setDescription(@Nullable String description) {
        this.context.setDescription(description);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.context.getDescription();
    }

    @Override
    public void setStatus(@Nullable SpanStatus status) {
        this.context.setStatus(status);
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return this.context.getStatus();
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return this.context;
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
        this.context.setTag(key, value);
    }

    @Override
    @Nullable
    public String getTag(@NotNull String key) {
        return this.context.getTags().get(key);
    }

    @Override
    public boolean isFinished() {
        return this.finished.get();
    }

    @Nullable
    public Boolean isSampled() {
        return this.context.getSampled();
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.throwable;
    }

    @NotNull
    public SentryId getTraceId() {
        return this.context.getTraceId();
    }

    @NotNull
    public SpanId getSpanId() {
        return this.context.getSpanId();
    }

    @Nullable
    public SpanId getParentSpanId() {
        return this.context.getParentSpanId();
    }

    public Map<String, String> getTags() {
        return this.context.getTags();
    }
}

