/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rocketmq.sink;

import com.google.auto.service.AutoService;
import java.io.IOException;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.common.RocketMqBaseConfiguration;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.common.SchemaFormat;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.config.ProducerConfig;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.exception.RocketMqConnectorException;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.sink.ProducerMetadata;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.sink.RocketMqSinkWriter;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSink.class})
public class RocketMqSink
extends AbstractSimpleSink<SeaTunnelRow, Void> {
    private static final String DEFAULT_PRODUCER_GROUP = "SeaTunnel-Producer-Group";
    private SeaTunnelRowType seaTunnelRowType;
    private ProducerMetadata producerMetadata;

    public String getPluginName() {
        return "Rocketmq";
    }

    public void prepare(Config config) throws PrepareFailException {
        CheckResult result = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{ProducerConfig.TOPIC.key(), org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.NAME_SRV_ADDR.key()});
        if (!result.isSuccess()) {
            throw new RocketMqConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SINK, result.getMsg()));
        }
        this.producerMetadata = new ProducerMetadata();
        this.producerMetadata.setTopic(config.getString(ProducerConfig.TOPIC.key()));
        RocketMqBaseConfiguration.Builder baseConfigurationBuilder = RocketMqBaseConfiguration.newBuilder().producer().namesrvAddr(config.getString(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.NAME_SRV_ADDR.key()));
        boolean aclEnabled = (Boolean)org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.ACL_ENABLED.defaultValue();
        if (config.hasPath(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.ACL_ENABLED.key())) {
            aclEnabled = config.getBoolean(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.ACL_ENABLED.key());
            if (!(!aclEnabled || config.hasPath(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.ACCESS_KEY.key()) && config.hasPath(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.SECRET_KEY.key()))) {
                throw new RocketMqConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.OPTION_VALIDATION_FAILED, "When ACL_ENABLED true , ACCESS_KEY and SECRET_KEY must be configured");
            }
            if (config.hasPath(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.ACCESS_KEY.key())) {
                baseConfigurationBuilder.accessKey(config.getString(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.ACCESS_KEY.key()));
            }
            if (config.hasPath(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.SECRET_KEY.key())) {
                baseConfigurationBuilder.secretKey(config.getString(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.SECRET_KEY.key()));
            }
        }
        baseConfigurationBuilder.aclEnable(aclEnabled);
        if (config.hasPath(ProducerConfig.PRODUCER_GROUP.key())) {
            baseConfigurationBuilder.groupId(config.getString(ProducerConfig.PRODUCER_GROUP.key()));
        } else {
            baseConfigurationBuilder.groupId(DEFAULT_PRODUCER_GROUP);
        }
        if (config.hasPath(ProducerConfig.MAX_MESSAGE_SIZE.key())) {
            baseConfigurationBuilder.maxMessageSize(config.getInt(ProducerConfig.MAX_MESSAGE_SIZE.key()));
        } else {
            baseConfigurationBuilder.maxMessageSize((Integer)ProducerConfig.MAX_MESSAGE_SIZE.defaultValue());
        }
        if (config.hasPath(ProducerConfig.SEND_MESSAGE_TIMEOUT_MILLIS.key())) {
            baseConfigurationBuilder.sendMsgTimeout(config.getInt(ProducerConfig.SEND_MESSAGE_TIMEOUT_MILLIS.key()));
        } else {
            baseConfigurationBuilder.sendMsgTimeout((Integer)ProducerConfig.SEND_MESSAGE_TIMEOUT_MILLIS.defaultValue());
        }
        this.producerMetadata.setConfiguration(baseConfigurationBuilder.build());
        if (config.hasPath(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.FORMAT.key())) {
            this.producerMetadata.setFormat(SchemaFormat.valueOf(config.getString(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.FORMAT.key()).toUpperCase()));
        } else {
            this.producerMetadata.setFormat(SchemaFormat.JSON);
        }
        if (config.hasPath(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.FIELD_DELIMITER.key())) {
            this.producerMetadata.setFieldDelimiter(config.getString(org.apache.seatunnel.connectors.seatunnel.rocketmq.config.Config.FIELD_DELIMITER.key()));
        } else {
            this.producerMetadata.setFieldDelimiter(",");
        }
        if (config.hasPath(ProducerConfig.PARTITION_KEY_FIELDS.key())) {
            this.producerMetadata.setPartitionKeyFields(config.getStringList(ProducerConfig.PARTITION_KEY_FIELDS.key()));
        }
        boolean exactlyOnce = (Boolean)ProducerConfig.EXACTLY_ONCE.defaultValue();
        if (config.hasPath(ProducerConfig.EXACTLY_ONCE.key())) {
            exactlyOnce = config.getBoolean(ProducerConfig.EXACTLY_ONCE.key());
        }
        this.producerMetadata.setExactlyOnce(exactlyOnce);
        boolean sync = (Boolean)ProducerConfig.SEND_SYNC.defaultValue();
        if (config.hasPath(ProducerConfig.SEND_SYNC.key())) {
            sync = config.getBoolean(ProducerConfig.SEND_SYNC.key());
        }
        this.producerMetadata.setSync(sync);
    }

    public void setTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    @Override
    public AbstractSinkWriter<SeaTunnelRow, Void> createWriter(SinkWriter.Context context) throws IOException {
        return new RocketMqSinkWriter(this.producerMetadata, this.seaTunnelRowType);
    }
}

