/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rocketmq.serialize;

import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import org.apache.rocketmq.common.message.Message;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.common.SchemaFormat;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.serialize.SeaTunnelRowSerializer;
import org.apache.seatunnel.format.json.JsonSerializationSchema;
import org.apache.seatunnel.format.json.exception.SeaTunnelJsonFormatException;
import org.apache.seatunnel.format.text.TextSerializationSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSeaTunnelRowSerializer
implements SeaTunnelRowSerializer<byte[], byte[]> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSeaTunnelRowSerializer.class);
    private final String topic;
    private final SerializationSchema keySerialization;
    private final SerializationSchema valueSerialization;

    public DefaultSeaTunnelRowSerializer(String topic, SeaTunnelRowType seaTunnelRowType, SchemaFormat format, String delimiter) {
        this(topic, (SerializationSchema & Serializable)element -> null, DefaultSeaTunnelRowSerializer.createSerializationSchema(seaTunnelRowType, format, delimiter));
    }

    public DefaultSeaTunnelRowSerializer(String topic, List<String> keyFieldNames, SeaTunnelRowType seaTunnelRowType, SchemaFormat format, String delimiter) {
        this(topic, DefaultSeaTunnelRowSerializer.createKeySerializationSchema(keyFieldNames, seaTunnelRowType), DefaultSeaTunnelRowSerializer.createSerializationSchema(seaTunnelRowType, format, delimiter));
    }

    public DefaultSeaTunnelRowSerializer(String topic, SerializationSchema keySerialization, SerializationSchema valueSerialization) {
        this.topic = topic;
        this.keySerialization = keySerialization;
        this.valueSerialization = valueSerialization;
    }

    private static SerializationSchema createSerializationSchema(SeaTunnelRowType rowType, SchemaFormat format, String delimiter) {
        switch (format) {
            case TEXT: {
                return TextSerializationSchema.builder().seaTunnelRowType(rowType).delimiter(delimiter).build();
            }
            case JSON: {
                return new JsonSerializationSchema(rowType);
            }
        }
        throw new SeaTunnelJsonFormatException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unsupported format: " + (Object)((Object)format));
    }

    private static SerializationSchema createKeySerializationSchema(List<String> keyFieldNames, SeaTunnelRowType seaTunnelRowType) {
        if (keyFieldNames == null || keyFieldNames.isEmpty()) {
            return (SerializationSchema & Serializable)element -> null;
        }
        int[] keyFieldIndexArr = new int[keyFieldNames.size()];
        SeaTunnelDataType[] keyFieldDataTypeArr = new SeaTunnelDataType[keyFieldNames.size()];
        for (int i = 0; i < keyFieldNames.size(); ++i) {
            int rowFieldIndex;
            String keyFieldName = keyFieldNames.get(i);
            keyFieldIndexArr[i] = rowFieldIndex = seaTunnelRowType.indexOf(keyFieldName);
            keyFieldDataTypeArr[i] = seaTunnelRowType.getFieldType(rowFieldIndex);
        }
        SeaTunnelRowType keyType = new SeaTunnelRowType(keyFieldNames.toArray(new String[0]), keyFieldDataTypeArr);
        JsonSerializationSchema keySerializationSchema = new JsonSerializationSchema(keyType);
        Function<SeaTunnelRow, SeaTunnelRow> keyDataExtractor = row -> {
            Object[] keyFields = new Object[keyFieldIndexArr.length];
            for (int i = 0; i < keyFieldIndexArr.length; ++i) {
                keyFields[i] = row.getField(keyFieldIndexArr[i]);
            }
            return new SeaTunnelRow(keyFields);
        };
        return (SerializationSchema & Serializable)row -> keySerializationSchema.serialize((SeaTunnelRow)keyDataExtractor.apply(row));
    }

    @Override
    public Message serializeRow(SeaTunnelRow row) {
        byte[] value = this.valueSerialization.serialize(row);
        if (value == null) {
            return null;
        }
        byte[] key = this.keySerialization.serialize(row);
        return new Message(this.topic, null, key == null ? null : new String(key), value);
    }
}

