/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.consumer;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.store.OffsetStore;
import org.apache.rocketmq.client.consumer.store.ReadOffsetType;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.impl.consumer.PullRequest;
import org.apache.rocketmq.client.impl.consumer.RebalanceImpl;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;

public class RebalancePushImpl
extends RebalanceImpl {
    private static final long UNLOCK_DELAY_TIME_MILLS = Long.parseLong(System.getProperty("rocketmq.client.unlockDelayTimeMills", "20000"));
    private final DefaultMQPushConsumerImpl defaultMQPushConsumerImpl;

    public RebalancePushImpl(DefaultMQPushConsumerImpl defaultMQPushConsumerImpl) {
        this(null, null, null, null, defaultMQPushConsumerImpl);
    }

    public RebalancePushImpl(String consumerGroup, MessageModel messageModel, AllocateMessageQueueStrategy allocateMessageQueueStrategy, MQClientInstance mQClientFactory, DefaultMQPushConsumerImpl defaultMQPushConsumerImpl) {
        super(consumerGroup, messageModel, allocateMessageQueueStrategy, mQClientFactory);
        this.defaultMQPushConsumerImpl = defaultMQPushConsumerImpl;
    }

    @Override
    public void messageQueueChanged(String topic, Set<MessageQueue> mqAll, Set<MessageQueue> mqDivided) {
        SubscriptionData subscriptionData = (SubscriptionData)this.subscriptionInner.get(topic);
        long newVersion = System.currentTimeMillis();
        log.info("{} Rebalance changed, also update version: {}, {}", topic, subscriptionData.getSubVersion(), newVersion);
        subscriptionData.setSubVersion(newVersion);
        int currentQueueCount = this.processQueueTable.size();
        if (currentQueueCount != 0) {
            int pullThresholdSizeForTopic;
            int pullThresholdForTopic = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdForTopic();
            if (pullThresholdForTopic != -1) {
                int newVal = Math.max(1, pullThresholdForTopic / currentQueueCount);
                log.info("The pullThresholdForQueue is changed from {} to {}", (Object)this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdForQueue(), (Object)newVal);
                this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().setPullThresholdForQueue(newVal);
            }
            if ((pullThresholdSizeForTopic = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdSizeForTopic()) != -1) {
                int newVal = Math.max(1, pullThresholdSizeForTopic / currentQueueCount);
                log.info("The pullThresholdSizeForQueue is changed from {} to {}", (Object)this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdSizeForQueue(), (Object)newVal);
                this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().setPullThresholdSizeForQueue(newVal);
            }
        }
        this.getmQClientFactory().sendHeartbeatToAllBrokerWithLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeUnnecessaryMessageQueue(MessageQueue mq, ProcessQueue pq) {
        this.defaultMQPushConsumerImpl.getOffsetStore().persist(mq);
        this.defaultMQPushConsumerImpl.getOffsetStore().removeOffset(mq);
        if (!this.defaultMQPushConsumerImpl.isConsumeOrderly()) return true;
        if (!MessageModel.CLUSTERING.equals((Object)this.defaultMQPushConsumerImpl.messageModel())) return true;
        try {
            if (!pq.getConsumeLock().tryLock(1000L, TimeUnit.MILLISECONDS)) {
                log.warn("[WRONG]mq is consuming, so can not unlock it, {}. maybe hanged for a while, {}", (Object)mq, (Object)pq.getTryUnlockTimes());
                pq.incTryUnlockTimes();
                return false;
            }
            try {
                boolean bl = this.unlockDelay(mq, pq);
                return bl;
            }
            finally {
                pq.getConsumeLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("removeUnnecessaryMessageQueue Exception", e);
        }
        return false;
    }

    private boolean unlockDelay(final MessageQueue mq, ProcessQueue pq) {
        if (pq.hasTempMessage()) {
            log.info("[{}]unlockDelay, begin {} ", (Object)mq.hashCode(), (Object)mq);
            this.defaultMQPushConsumerImpl.getmQClientFactory().getScheduledExecutorService().schedule(new Runnable(){

                @Override
                public void run() {
                    RebalanceImpl.log.info("[{}]unlockDelay, execute at once {}", (Object)mq.hashCode(), (Object)mq);
                    RebalancePushImpl.this.unlock(mq, true);
                }
            }, UNLOCK_DELAY_TIME_MILLS, TimeUnit.MILLISECONDS);
        } else {
            this.unlock(mq, true);
        }
        return true;
    }

    @Override
    public ConsumeType consumeType() {
        return ConsumeType.CONSUME_PASSIVELY;
    }

    @Override
    public void removeDirtyOffset(MessageQueue mq) {
        this.defaultMQPushConsumerImpl.getOffsetStore().removeOffset(mq);
    }

    @Override
    @Deprecated
    public long computePullFromWhere(MessageQueue mq) {
        long result = -1L;
        try {
            result = this.computePullFromWhereWithException(mq);
        }
        catch (MQClientException e) {
            log.warn("Compute consume offset exception, mq={}", (Object)mq);
        }
        return result;
    }

    @Override
    public long computePullFromWhereWithException(MessageQueue mq) throws MQClientException {
        long result = -1L;
        ConsumeFromWhere consumeFromWhere = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getConsumeFromWhere();
        OffsetStore offsetStore = this.defaultMQPushConsumerImpl.getOffsetStore();
        switch (consumeFromWhere) {
            case CONSUME_FROM_LAST_OFFSET_AND_FROM_MIN_WHEN_BOOT_FIRST: 
            case CONSUME_FROM_MIN_OFFSET: 
            case CONSUME_FROM_MAX_OFFSET: 
            case CONSUME_FROM_LAST_OFFSET: {
                long lastOffset = offsetStore.readOffset(mq, ReadOffsetType.READ_FROM_STORE);
                if (lastOffset >= 0L) {
                    result = lastOffset;
                    break;
                }
                if (-1L == lastOffset) {
                    if (mq.getTopic().startsWith("%RETRY%")) {
                        result = 0L;
                        break;
                    }
                    try {
                        result = this.mQClientFactory.getMQAdminImpl().maxOffset(mq);
                        break;
                    }
                    catch (MQClientException e) {
                        log.warn("Compute consume offset from last offset exception, mq={}, exception={}", (Object)mq, (Object)e);
                        throw e;
                    }
                }
                result = -1L;
                break;
            }
            case CONSUME_FROM_FIRST_OFFSET: {
                long lastOffset = offsetStore.readOffset(mq, ReadOffsetType.READ_FROM_STORE);
                if (lastOffset >= 0L) {
                    result = lastOffset;
                    break;
                }
                if (-1L == lastOffset) {
                    result = 0L;
                    break;
                }
                result = -1L;
                break;
            }
            case CONSUME_FROM_TIMESTAMP: {
                long lastOffset = offsetStore.readOffset(mq, ReadOffsetType.READ_FROM_STORE);
                if (lastOffset >= 0L) {
                    result = lastOffset;
                    break;
                }
                if (-1L == lastOffset) {
                    if (mq.getTopic().startsWith("%RETRY%")) {
                        try {
                            result = this.mQClientFactory.getMQAdminImpl().maxOffset(mq);
                            break;
                        }
                        catch (MQClientException e) {
                            log.warn("Compute consume offset from last offset exception, mq={}, exception={}", (Object)mq, (Object)e);
                            throw e;
                        }
                    }
                    try {
                        long timestamp = UtilAll.parseDate(this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getConsumeTimestamp(), "yyyyMMddHHmmss").getTime();
                        result = this.mQClientFactory.getMQAdminImpl().searchOffset(mq, timestamp);
                        break;
                    }
                    catch (MQClientException e) {
                        log.warn("Compute consume offset from last offset exception, mq={}, exception={}", (Object)mq, (Object)e);
                        throw e;
                    }
                }
                result = -1L;
                break;
            }
        }
        return result;
    }

    @Override
    public void dispatchPullRequest(List<PullRequest> pullRequestList) {
        for (PullRequest pullRequest : pullRequestList) {
            this.defaultMQPushConsumerImpl.executePullRequestImmediately(pullRequest);
            log.info("doRebalance, {}, add a new pull request {}", (Object)this.consumerGroup, (Object)pullRequest);
        }
    }
}

