/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.sink;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisDataType;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisParameters;
import org.apache.seatunnel.format.json.JsonSerializationSchema;
import redis.clients.jedis.Jedis;

public class RedisSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private final SeaTunnelRowType seaTunnelRowType;
    private final RedisParameters redisParameters;
    private final SerializationSchema serializationSchema;
    private final Jedis jedis;

    public RedisSinkWriter(SeaTunnelRowType seaTunnelRowType, RedisParameters redisParameters) {
        this.seaTunnelRowType = seaTunnelRowType;
        this.redisParameters = redisParameters;
        this.serializationSchema = new JsonSerializationSchema(seaTunnelRowType);
        this.jedis = redisParameters.buildJedis();
    }

    public void write(SeaTunnelRow element) throws IOException {
        String data = new String(this.serializationSchema.serialize(element));
        RedisDataType redisDataType = this.redisParameters.getRedisDataType();
        String keyField = this.redisParameters.getKeyField();
        List<String> fields = Arrays.asList(this.seaTunnelRowType.getFieldNames());
        String key = fields.contains(keyField) ? element.getField(fields.indexOf(keyField)).toString() : keyField;
        long expire = this.redisParameters.getExpire();
        redisDataType.set(this.jedis, key, data, expire);
    }

    public void close() throws IOException {
        if (Objects.nonNull(this.jedis)) {
            this.jedis.close();
        }
    }
}

