/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.redis.config.JedisWrapper;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisConfig;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisDataType;
import org.apache.seatunnel.connectors.seatunnel.redis.exception.RedisConnectorException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

public class RedisParameters
implements Serializable {
    private String host;
    private int port;
    private String auth = "";
    private String user = "";
    private String keysPattern;
    private String keyField;
    private RedisDataType redisDataType;
    private RedisConfig.RedisMode mode;
    private RedisConfig.HashKeyParseMode hashKeyParseMode;
    private List<String> redisNodes = Collections.emptyList();
    private long expire = (Long)RedisConfig.EXPIRE.defaultValue();

    public void buildWithConfig(Config config) {
        this.host = config.getString(RedisConfig.HOST.key());
        this.port = config.getInt(RedisConfig.PORT.key());
        if (config.hasPath(RedisConfig.AUTH.key())) {
            this.auth = config.getString(RedisConfig.AUTH.key());
        }
        if (config.hasPath(RedisConfig.USER.key())) {
            this.user = config.getString(RedisConfig.USER.key());
        }
        this.mode = config.hasPath(RedisConfig.MODE.key()) ? RedisConfig.RedisMode.valueOf(config.getString(RedisConfig.MODE.key()).toUpperCase()) : (RedisConfig.RedisMode)((Object)RedisConfig.MODE.defaultValue());
        this.hashKeyParseMode = config.hasPath(RedisConfig.HASH_KEY_PARSE_MODE.key()) ? RedisConfig.HashKeyParseMode.valueOf(config.getString(RedisConfig.HASH_KEY_PARSE_MODE.key()).toUpperCase()) : (RedisConfig.HashKeyParseMode)((Object)RedisConfig.HASH_KEY_PARSE_MODE.defaultValue());
        if (config.hasPath(RedisConfig.NODES.key())) {
            this.redisNodes = config.getStringList(RedisConfig.NODES.key());
        }
        if (config.hasPath(RedisConfig.KEY.key())) {
            this.keyField = config.getString(RedisConfig.KEY.key());
        }
        if (config.hasPath(RedisConfig.KEY_PATTERN.key())) {
            this.keysPattern = config.getString(RedisConfig.KEY_PATTERN.key());
        }
        if (config.hasPath(RedisConfig.EXPIRE.key())) {
            this.expire = config.getLong(RedisConfig.EXPIRE.key());
        }
        try {
            String dataType = config.getString(RedisConfig.DATA_TYPE.key());
            this.redisDataType = RedisDataType.valueOf(dataType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new RedisConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Redis source connector only support these data types [key, hash, list, set, zset]", e);
        }
    }

    public Jedis buildJedis() {
        switch (this.mode) {
            case SINGLE: {
                Jedis jedis = new Jedis(this.host, this.port);
                if (StringUtils.isNotBlank((CharSequence)this.auth)) {
                    jedis.auth(this.auth);
                }
                if (StringUtils.isNotBlank((CharSequence)this.user)) {
                    jedis.aclSetUser(this.user);
                }
                return jedis;
            }
            case CLUSTER: {
                HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
                HostAndPort node = new HostAndPort(this.host, this.port);
                nodes.add(node);
                if (!this.redisNodes.isEmpty()) {
                    for (String redisNode : this.redisNodes) {
                        String[] splits = redisNode.split(":");
                        if (splits.length != 2) {
                            throw new RedisConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, "Invalid redis node information,redis node information must like as the following: [host:port]");
                        }
                        HostAndPort hostAndPort = new HostAndPort(splits[0], Integer.parseInt(splits[1]));
                        nodes.add(hostAndPort);
                    }
                }
                ConnectionPoolConfig connectionPoolConfig = new ConnectionPoolConfig();
                JedisCluster jedisCluster = StringUtils.isNotBlank((CharSequence)this.auth) ? new JedisCluster(nodes, 2000, 2000, 5, this.auth, (GenericObjectPoolConfig<Connection>)connectionPoolConfig) : new JedisCluster(nodes);
                return new JedisWrapper(jedisCluster);
            }
        }
        throw new RedisConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, "Not support this redis mode");
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuth() {
        return this.auth;
    }

    public String getUser() {
        return this.user;
    }

    public String getKeysPattern() {
        return this.keysPattern;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public RedisDataType getRedisDataType() {
        return this.redisDataType;
    }

    public RedisConfig.RedisMode getMode() {
        return this.mode;
    }

    public RedisConfig.HashKeyParseMode getHashKeyParseMode() {
        return this.hashKeyParseMode;
    }

    public List<String> getRedisNodes() {
        return this.redisNodes;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setKeysPattern(String keysPattern) {
        this.keysPattern = keysPattern;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public void setRedisDataType(RedisDataType redisDataType) {
        this.redisDataType = redisDataType;
    }

    public void setMode(RedisConfig.RedisMode mode) {
        this.mode = mode;
    }

    public void setHashKeyParseMode(RedisConfig.HashKeyParseMode hashKeyParseMode) {
        this.hashKeyParseMode = hashKeyParseMode;
    }

    public void setRedisNodes(List<String> redisNodes) {
        this.redisNodes = redisNodes;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisParameters)) {
            return false;
        }
        RedisParameters other = (RedisParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getExpire() != other.getExpire()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$auth = this.getAuth();
        String other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$keysPattern = this.getKeysPattern();
        String other$keysPattern = other.getKeysPattern();
        if (this$keysPattern == null ? other$keysPattern != null : !this$keysPattern.equals(other$keysPattern)) {
            return false;
        }
        String this$keyField = this.getKeyField();
        String other$keyField = other.getKeyField();
        if (this$keyField == null ? other$keyField != null : !this$keyField.equals(other$keyField)) {
            return false;
        }
        RedisDataType this$redisDataType = this.getRedisDataType();
        RedisDataType other$redisDataType = other.getRedisDataType();
        if (this$redisDataType == null ? other$redisDataType != null : !((Object)((Object)this$redisDataType)).equals((Object)other$redisDataType)) {
            return false;
        }
        RedisConfig.RedisMode this$mode = this.getMode();
        RedisConfig.RedisMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        RedisConfig.HashKeyParseMode this$hashKeyParseMode = this.getHashKeyParseMode();
        RedisConfig.HashKeyParseMode other$hashKeyParseMode = other.getHashKeyParseMode();
        if (this$hashKeyParseMode == null ? other$hashKeyParseMode != null : !((Object)((Object)this$hashKeyParseMode)).equals((Object)other$hashKeyParseMode)) {
            return false;
        }
        List<String> this$redisNodes = this.getRedisNodes();
        List<String> other$redisNodes = other.getRedisNodes();
        return !(this$redisNodes == null ? other$redisNodes != null : !((Object)this$redisNodes).equals(other$redisNodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        long $expire = this.getExpire();
        result = result * 59 + (int)($expire >>> 32 ^ $expire);
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $keysPattern = this.getKeysPattern();
        result = result * 59 + ($keysPattern == null ? 43 : $keysPattern.hashCode());
        String $keyField = this.getKeyField();
        result = result * 59 + ($keyField == null ? 43 : $keyField.hashCode());
        RedisDataType $redisDataType = this.getRedisDataType();
        result = result * 59 + ($redisDataType == null ? 43 : ((Object)((Object)$redisDataType)).hashCode());
        RedisConfig.RedisMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        RedisConfig.HashKeyParseMode $hashKeyParseMode = this.getHashKeyParseMode();
        result = result * 59 + ($hashKeyParseMode == null ? 43 : ((Object)((Object)$hashKeyParseMode)).hashCode());
        List<String> $redisNodes = this.getRedisNodes();
        result = result * 59 + ($redisNodes == null ? 43 : ((Object)$redisNodes).hashCode());
        return result;
    }

    public String toString() {
        return "RedisParameters(host=" + this.getHost() + ", port=" + this.getPort() + ", auth=" + this.getAuth() + ", user=" + this.getUser() + ", keysPattern=" + this.getKeysPattern() + ", keyField=" + this.getKeyField() + ", redisDataType=" + (Object)((Object)this.getRedisDataType()) + ", mode=" + (Object)((Object)this.getMode()) + ", hashKeyParseMode=" + (Object)((Object)this.getHashKeyParseMode()) + ", redisNodes=" + this.getRedisNodes() + ", expire=" + this.getExpire() + ")";
    }
}

