/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.common.utils.JsonUtils;
import redis.clients.jedis.Jedis;

public enum RedisDataType {
    KEY{

        @Override
        public void set(Jedis jedis, String key, String value) {
            jedis.set(key, value);
        }

        @Override
        public List<String> get(Jedis jedis, String key) {
            return Collections.singletonList(jedis.get(key));
        }
    }
    ,
    HASH{

        @Override
        public void set(Jedis jedis, String key, String value) {
            Map fieldsMap = JsonUtils.toMap((String)value);
            jedis.hset(key, fieldsMap);
        }

        @Override
        public List<String> get(Jedis jedis, String key) {
            Map<String, String> kvMap = jedis.hgetAll(key);
            return Collections.singletonList(JsonUtils.toJsonString(kvMap));
        }
    }
    ,
    LIST{

        @Override
        public void set(Jedis jedis, String key, String value) {
            jedis.lpush(key, value);
        }

        @Override
        public List<String> get(Jedis jedis, String key) {
            return jedis.lrange(key, 0L, -1L);
        }
    }
    ,
    SET{

        @Override
        public void set(Jedis jedis, String key, String value) {
            jedis.sadd(key, value);
        }

        @Override
        public List<String> get(Jedis jedis, String key) {
            Set<String> members = jedis.smembers(key);
            return new ArrayList<String>(members);
        }
    }
    ,
    ZSET{

        @Override
        public void set(Jedis jedis, String key, String value) {
            jedis.zadd(key, 1.0, value);
        }

        @Override
        public List<String> get(Jedis jedis, String key) {
            return jedis.zrange(key, 0L, -1L);
        }
    };


    public List<String> get(Jedis jedis, String key) {
        return Collections.emptyList();
    }

    public void set(Jedis jedis, String key, String value) {
    }
}

