/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.config;

import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;

public class RedisConfig {
    public static final Option<String> HOST = Options.key((String)"host").stringType().noDefaultValue().withDescription("redis hostname or ip");
    public static final Option<String> PORT = Options.key((String)"port").stringType().noDefaultValue().withDescription("redis port");
    public static final Option<String> AUTH = Options.key((String)"auth").stringType().noDefaultValue().withDescription("redis authentication password, you need it when you connect to an encrypted cluster");
    public static final Option<String> USER = Options.key((String)"user").stringType().noDefaultValue().withDescription("redis authentication user, you need it when you connect to an encrypted cluster");
    public static final Option<String> KEY_PATTERN = Options.key((String)"keys").stringType().noDefaultValue().withDescription("keys pattern, redis source connector support fuzzy key matching, user needs to ensure that the matched keys are the same type");
    public static final Option<String> KEY = Options.key((String)"key").stringType().noDefaultValue().withDescription("The value of key you want to write to redis.");
    public static final Option<String> DATA_TYPE = Options.key((String)"data_type").stringType().noDefaultValue().withDescription("redis data types, support key hash list set zset.");
    public static final Option<Format> FORMAT = Options.key((String)"format").enumType(Format.class).defaultValue((Object)Format.JSON).withDescription("the format of upstream data, now only support json and text, default json.");
    public static final Option<RedisMode> MODE = Options.key((String)"mode").enumType(RedisMode.class).defaultValue((Object)RedisMode.SINGLE).withDescription("redis mode, support single or cluster, default value is single");
    public static final Option<String> NODES = Options.key((String)"nodes").stringType().noDefaultValue().withDescription("redis nodes information, used in cluster mode, must like as the following format: [host1:port1, host2:port2]");
    public static final Option<HashKeyParseMode> HASH_KEY_PARSE_MODE = Options.key((String)"hash_key_parse_mode").enumType(HashKeyParseMode.class).defaultValue((Object)HashKeyParseMode.ALL).withDescription("hash key parse mode, support all or kv, default value is all");

    public static enum Format {
        JSON;

    }

    public static enum HashKeyParseMode {
        ALL,
        KV;

    }

    public static enum RedisMode {
        SINGLE,
        CLUSTER;

    }
}

