/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rabbitmq.sink;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqConfig;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.sink.RabbitmqSink;

@AutoService(value={Factory.class})
public class RabbitmqSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "RabbitMQ";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{RabbitmqSinkOptions.HOST, RabbitmqSinkOptions.PORT, RabbitmqSinkOptions.VIRTUAL_HOST, RabbitmqSinkOptions.QUEUE_NAME}).bundled(new Option[]{RabbitmqSinkOptions.USERNAME, RabbitmqSinkOptions.PASSWORD}).optional(new Option[]{RabbitmqSinkOptions.URL, RabbitmqSinkOptions.ROUTING_KEY, RabbitmqSinkOptions.EXCHANGE, RabbitmqSinkOptions.NETWORK_RECOVERY_INTERVAL, RabbitmqSinkOptions.TOPOLOGY_RECOVERY_ENABLED, RabbitmqSinkOptions.AUTOMATIC_RECOVERY_ENABLED, RabbitmqSinkOptions.CONNECTION_TIMEOUT, RabbitmqSinkOptions.FOR_E2E_TESTING, RabbitmqSinkOptions.DURABLE, RabbitmqSinkOptions.EXCLUSIVE, RabbitmqSinkOptions.AUTO_DELETE, RabbitmqSinkOptions.RABBITMQ_CONFIG}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        return () -> new RabbitmqSink(new RabbitmqConfig(context.getOptions()), context.getCatalogTable());
    }
}

