/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.neo4j.config;

import java.util.Map;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jQueryInfo;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.neo4j.constants.SinkWriteMode;
import org.apache.seatunnel.connectors.seatunnel.neo4j.exception.Neo4jConnectorException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class Neo4jSinkQueryInfo
extends Neo4jQueryInfo {
    private Map<String, Object> queryParamPosition;
    private Integer maxBatchSize;
    private SinkWriteMode writeMode;

    public boolean batchMode() {
        return SinkWriteMode.BATCH.equals((Object)this.writeMode);
    }

    public Neo4jSinkQueryInfo(Config config) {
        super(config, PluginType.SINK);
        this.writeMode = this.prepareWriteMode(config);
        if (SinkWriteMode.BATCH.equals((Object)this.writeMode)) {
            this.prepareBatchWriteConfig(config);
        } else {
            this.prepareOneByOneConfig(config);
        }
    }

    private void prepareOneByOneConfig(Config config) {
        CheckResult queryConfigCheck = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{Neo4jSinkConfig.QUERY_PARAM_POSITION.key()});
        if (!queryConfigCheck.isSuccess()) {
            throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", "Neo4j", PluginType.SINK, queryConfigCheck.getMsg()));
        }
        this.queryParamPosition = config.getObject(Neo4jSinkConfig.QUERY_PARAM_POSITION.key()).unwrapped();
    }

    private void prepareBatchWriteConfig(Config config) {
        if (config.hasPath(Neo4jSinkConfig.MAX_BATCH_SIZE.key())) {
            int batchSize = config.getInt(Neo4jSinkConfig.MAX_BATCH_SIZE.key());
            if (batchSize <= 0) {
                throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", "Neo4j", PluginType.SINK, "maxBatchSize must greater than 0"));
            }
            this.maxBatchSize = batchSize;
        } else {
            this.maxBatchSize = (Integer)Neo4jSinkConfig.MAX_BATCH_SIZE.defaultValue();
        }
    }

    private SinkWriteMode prepareWriteMode(Config config) {
        if (config.hasPath(Neo4jSinkConfig.WRITE_MODE.key())) {
            return (SinkWriteMode)config.getEnum(SinkWriteMode.class, Neo4jSinkConfig.WRITE_MODE.key());
        }
        return (SinkWriteMode)((Object)Neo4jSinkConfig.WRITE_MODE.defaultValue());
    }

    public Map<String, Object> getQueryParamPosition() {
        return this.queryParamPosition;
    }

    public Integer getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public SinkWriteMode getWriteMode() {
        return this.writeMode;
    }

    public void setQueryParamPosition(Map<String, Object> queryParamPosition) {
        this.queryParamPosition = queryParamPosition;
    }

    public void setMaxBatchSize(Integer maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public void setWriteMode(SinkWriteMode writeMode) {
        this.writeMode = writeMode;
    }
}

