/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.neo4j.sink;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jSinkQueryInfo;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Query;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jSinkWriter
implements SinkWriter<SeaTunnelRow, Void, Void> {
    private static final Logger log = LoggerFactory.getLogger(Neo4jSinkWriter.class);
    private final Neo4jSinkQueryInfo neo4jSinkQueryInfo;
    private final transient Driver driver;
    private final transient Session session;

    public Neo4jSinkWriter(Neo4jSinkQueryInfo neo4jSinkQueryInfo) {
        this.neo4jSinkQueryInfo = neo4jSinkQueryInfo;
        this.driver = this.neo4jSinkQueryInfo.getDriverBuilder().build();
        this.session = this.driver.session(SessionConfig.forDatabase(neo4jSinkQueryInfo.getDriverBuilder().getDatabase()));
    }

    public void write(SeaTunnelRow element) throws IOException {
        Map<String, Object> queryParamPosition = this.neo4jSinkQueryInfo.getQueryParamPosition().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> element.getField(((Integer)e.getValue()).intValue())));
        Query query = new Query(this.neo4jSinkQueryInfo.getQuery(), queryParamPosition);
        this.session.writeTransaction(tx -> {
            tx.run(query);
            return null;
        });
    }

    public Optional<Void> prepareCommit() throws IOException {
        return Optional.empty();
    }

    public void abortPrepare() {
    }

    public void close() throws IOException {
        this.session.close();
        this.driver.close();
    }
}

