/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.neo4j.sink;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jSinkQueryInfo;
import org.apache.seatunnel.connectors.seatunnel.neo4j.sink.Neo4jSink;

@AutoService(value={Factory.class})
public class Neo4jSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Neo4j";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{Neo4jSinkOptions.KEY_NEO4J_URI, Neo4jSinkOptions.KEY_DATABASE, Neo4jSinkOptions.KEY_QUERY, Neo4jSinkOptions.QUERY_PARAM_POSITION}).optional(new Option[]{Neo4jSinkOptions.KEY_USERNAME, Neo4jSinkOptions.KEY_PASSWORD, Neo4jSinkOptions.KEY_BEARER_TOKEN, Neo4jSinkOptions.KEY_KERBEROS_TICKET, Neo4jSinkOptions.KEY_MAX_CONNECTION_TIMEOUT, Neo4jSinkOptions.KEY_MAX_TRANSACTION_RETRY_TIME}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        Neo4jSinkQueryInfo neo4jSinkQueryInfo = new Neo4jSinkQueryInfo(context.getOptions().toConfig());
        return () -> new Neo4jSink(context.getCatalogTable(), neo4jSinkQueryInfo);
    }
}

