/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.source.split;

import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.connectors.seatunnel.mongodb.internal.MongodbClientProvider;
import org.apache.seatunnel.connectors.seatunnel.mongodb.source.split.MongoSplit;
import org.apache.seatunnel.connectors.seatunnel.mongodb.source.split.MongoSplitStrategy;
import org.apache.seatunnel.connectors.seatunnel.mongodb.source.split.MongoSplitUtils;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.Document;
import org.bson.conversions.Bson;

public class SamplingSplitStrategy
implements MongoSplitStrategy,
Serializable {
    private final MongodbClientProvider clientProvider;
    private final String splitKey;
    private final BsonDocument matchQuery;
    private final BsonDocument projection;
    private final long samplesPerSplit;
    private final long sizePerSplit;

    SamplingSplitStrategy(MongodbClientProvider clientProvider, String splitKey, BsonDocument matchQuery, BsonDocument projection, long samplesPerSplit, long sizePerSplit) {
        this.clientProvider = clientProvider;
        this.splitKey = splitKey;
        this.matchQuery = matchQuery;
        this.projection = projection;
        this.samplesPerSplit = samplesPerSplit;
        this.sizePerSplit = sizePerSplit;
    }

    @Override
    public List<MongoSplit> split() {
        ImmutablePair<Long, Long> numAndAvgSize = this.getDocumentNumAndAvgSize();
        long count = (Long)numAndAvgSize.getLeft();
        long avgSize = (Long)numAndAvgSize.getRight();
        long numDocumentsPerSplit = this.sizePerSplit / avgSize;
        int numSplits = (int)Math.ceil((double)count / (double)numDocumentsPerSplit);
        int numSamples = (int)Math.floor(this.samplesPerSplit * (long)numSplits);
        if (numSplits == 0) {
            return Lists.newArrayList();
        }
        if (numSplits == 1) {
            return Lists.newArrayList((Object[])new MongoSplit[]{MongoSplitUtils.createMongoSplit(0, this.matchQuery, this.projection, this.splitKey, null, null)});
        }
        List<BsonDocument> samples = this.sampleCollection(numSamples);
        if (samples.isEmpty()) {
            return Collections.emptyList();
        }
        List<Object> rightBoundaries = IntStream.range(0, samples.size()).filter(i -> (long)i % this.samplesPerSplit == 0L || !this.matchQuery.isEmpty() && (long)i == count - 1L).mapToObj(i -> ((BsonDocument)samples.get(i)).get(this.splitKey)).collect(Collectors.toList());
        return this.createSplits(this.splitKey, rightBoundaries);
    }

    private ImmutablePair<Long, Long> getDocumentNumAndAvgSize() {
        String collectionName = this.clientProvider.getDefaultCollection().getNamespace().getCollectionName();
        BsonDocument statsCmd = new BsonDocument("collStats", new BsonString(collectionName));
        Document res = this.clientProvider.getDefaultDatabase().runCommand(statsCmd);
        Object count = res.get("count");
        long total = Optional.ofNullable(count).map(v -> Long.parseLong(String.valueOf(count))).orElse(0L);
        Object avgDocumentBytes = res.get("avgObjSize");
        long avgObjSize = Optional.ofNullable(avgDocumentBytes).map(docBytes -> {
            if (docBytes instanceof Integer) {
                return ((Integer)docBytes).longValue();
            }
            if (docBytes instanceof Double) {
                return ((Double)docBytes).longValue();
            }
            return 0L;
        }).orElse(0L);
        if (this.matchQuery == null || this.matchQuery.isEmpty()) {
            return ImmutablePair.of((Object)total, (Object)avgObjSize);
        }
        return ImmutablePair.of((Object)this.clientProvider.getDefaultCollection().countDocuments(this.matchQuery), (Object)avgObjSize);
    }

    private List<BsonDocument> sampleCollection(int numSamples) {
        return this.clientProvider.getDefaultCollection().aggregate(Lists.newArrayList((Object[])new Bson[]{Aggregates.match(this.matchQuery), Aggregates.sample(numSamples), Aggregates.project(Projections.include(this.splitKey)), Aggregates.sort(Sorts.ascending(this.splitKey))})).allowDiskUse(true).into(Lists.newArrayList());
    }

    private List<MongoSplit> createSplits(String splitKey, List<Object> rightBoundaries) {
        if (rightBoundaries.size() == 0) {
            return Collections.emptyList();
        }
        List<MongoSplit> splits = IntStream.range(0, rightBoundaries.size()).mapToObj(index -> {
            Object min = index > 0 ? rightBoundaries.get(index - 1) : null;
            return MongoSplitUtils.createMongoSplit(index, this.matchQuery, this.projection, splitKey, min, rightBoundaries.get(index));
        }).collect(Collectors.toList());
        Object lastBoundary = rightBoundaries.get(rightBoundaries.size() - 1);
        splits.add(MongoSplitUtils.createMongoSplit(splits.size(), this.matchQuery, this.projection, splitKey, lastBoundary, null));
        return splits;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MongodbClientProvider clientProvider = null;
        private String splitKey;
        private BsonDocument matchQuery = EMPTY_MATCH_QUERY;
        private BsonDocument projection = EMPTY_PROJECTION;
        private long samplesPerSplit = 10L;
        private long sizePerSplit;
        private static final BsonDocument EMPTY_MATCH_QUERY = new BsonDocument();
        private static final BsonDocument EMPTY_PROJECTION = new BsonDocument();
        private static final long DEFAULT_SAMPLES_PER_SPLIT = 10L;

        Builder() {
        }

        public Builder setClientProvider(MongodbClientProvider clientProvider) {
            this.clientProvider = clientProvider;
            return this;
        }

        public Builder setSplitKey(String splitKey) {
            this.splitKey = splitKey;
            return this;
        }

        public Builder setMatchQuery(BsonDocument matchQuery) {
            this.matchQuery = matchQuery;
            return this;
        }

        public Builder setProjection(BsonDocument projection) {
            this.projection = projection;
            return this;
        }

        public Builder setSamplesPerSplit(long samplesPerSplit) {
            this.samplesPerSplit = samplesPerSplit;
            return this;
        }

        public Builder setSizePerSplit(long sizePerSplit) {
            this.sizePerSplit = sizePerSplit;
            return this;
        }

        public SamplingSplitStrategy build() {
            Preconditions.checkNotNull((Object)this.clientProvider);
            return new SamplingSplitStrategy(this.clientProvider, this.splitKey, this.matchQuery, this.projection, this.samplesPerSplit, this.sizePerSplit);
        }
    }
}

