/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.source.reader;

import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.mongodb.internal.MongodbClientProvider;
import org.apache.seatunnel.connectors.seatunnel.mongodb.serde.DocumentDeserializer;
import org.apache.seatunnel.connectors.seatunnel.mongodb.source.config.MongodbReadOptions;
import org.apache.seatunnel.connectors.seatunnel.mongodb.source.split.MongoSplit;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbReader
implements SourceReader<SeaTunnelRow, MongoSplit> {
    private static final Logger log = LoggerFactory.getLogger(MongodbReader.class);
    private final Queue<MongoSplit> pendingSplits;
    private final DocumentDeserializer<SeaTunnelRow> deserializer;
    private final SourceReader.Context context;
    private final MongodbClientProvider clientProvider;
    private MongoCursor<BsonDocument> cursor;
    private final MongodbReadOptions readOptions;
    private volatile boolean noMoreSplit;

    public MongodbReader(SourceReader.Context context, MongodbClientProvider clientProvider, DocumentDeserializer<SeaTunnelRow> deserializer, MongodbReadOptions mongodbReadOptions) {
        this.deserializer = deserializer;
        this.context = context;
        this.clientProvider = clientProvider;
        this.pendingSplits = new ConcurrentLinkedDeque<MongoSplit>();
        this.readOptions = mongodbReadOptions;
    }

    public void open() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNext(Collector<SeaTunnelRow> output) {
        Object object = output.getCheckpointLock();
        synchronized (object) {
            MongoSplit currentSplit = this.pendingSplits.poll();
            if (currentSplit != null) {
                if (this.cursor != null) {
                    return;
                }
                log.info("Prepared to read split {}", (Object)currentSplit.splitId());
                try {
                    this.getCursor(currentSplit);
                    this.cursorToStream().map(this.deserializer::deserialize).forEach(arg_0 -> output.collect(arg_0));
                }
                finally {
                    this.closeCurrentSplit();
                }
            }
            if (this.noMoreSplit && this.pendingSplits.isEmpty()) {
                log.info("Closed the bounded mongodb source");
                this.context.signalNoMoreElement();
            }
        }
    }

    private void getCursor(MongoSplit split) {
        this.cursor = this.clientProvider.getDefaultCollection().find(split.getQuery()).projection(split.getProjection()).batchSize(this.readOptions.getFetchSize()).noCursorTimeout(this.readOptions.isNoCursorTimeout()).maxTime(this.readOptions.getMaxTimeMS(), TimeUnit.MINUTES).iterator();
    }

    private Stream<BsonDocument> cursorToStream() {
        Iterable iterable = () -> this.cursor;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public List<MongoSplit> snapshotState(long checkpointId) {
        return new ArrayList<MongoSplit>(this.pendingSplits);
    }

    public void addSplits(List<MongoSplit> splits) {
        log.info("Adding split(s) to reader: {}", splits);
        this.pendingSplits.addAll(splits);
    }

    public void handleNoMoreSplits() {
        log.info("receive no more splits message, this reader will not add new split.");
        this.noMoreSplit = true;
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }

    private void closeCurrentSplit() {
        Preconditions.checkNotNull(this.cursor);
        this.cursor.close();
        this.cursor = null;
    }
}

