/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.internal;

import com.google.common.base.Preconditions;
import org.apache.seatunnel.connectors.seatunnel.mongodb.internal.MongodbClientProvider;
import org.apache.seatunnel.connectors.seatunnel.mongodb.internal.MongodbSingleCollectionProvider;

public class MongodbCollectionProvider {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String connectionString;
        private String database;
        private String collection;

        public Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public MongodbClientProvider build() {
            Preconditions.checkNotNull((Object)this.connectionString, (Object)"Connection string must not be null");
            Preconditions.checkNotNull((Object)this.database, (Object)"Database must not be null");
            Preconditions.checkNotNull((Object)this.collection, (Object)"Collection must not be null");
            return new MongodbSingleCollectionProvider(this.connectionString, this.database, this.collection);
        }
    }
}

