/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.kafka.serialize;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.kafka.config.MessageFormat;
import org.apache.seatunnel.connectors.seatunnel.kafka.exception.KafkaConnectorException;
import org.apache.seatunnel.connectors.seatunnel.kafka.serialize.SeaTunnelRowSerializer;
import org.apache.seatunnel.format.compatible.debezium.json.CompatibleDebeziumJsonSerializationSchema;
import org.apache.seatunnel.format.json.JsonSerializationSchema;
import org.apache.seatunnel.format.json.canal.CanalJsonSerializationSchema;
import org.apache.seatunnel.format.json.debezium.DebeziumJsonSerializationSchema;
import org.apache.seatunnel.format.json.exception.SeaTunnelJsonFormatException;
import org.apache.seatunnel.format.text.TextSerializationSchema;

public class DefaultSeaTunnelRowSerializer
implements SeaTunnelRowSerializer {
    private final Function<SeaTunnelRow, String> topicExtractor;
    private final Function<SeaTunnelRow, Integer> partitionExtractor;
    private final Function<SeaTunnelRow, Long> timestampExtractor;
    private final Function<SeaTunnelRow, byte[]> keyExtractor;
    private final Function<SeaTunnelRow, byte[]> valueExtractor;
    private final Function<SeaTunnelRow, Iterable<Header>> headersExtractor;

    public ProducerRecord serializeRow(SeaTunnelRow row) {
        return new ProducerRecord<byte[], byte[]>(this.topicExtractor.apply(row), this.partitionExtractor.apply(row), this.timestampExtractor.apply(row), this.keyExtractor.apply(row), this.valueExtractor.apply(row), this.headersExtractor.apply(row));
    }

    public static DefaultSeaTunnelRowSerializer create(String topic, SeaTunnelRowType rowType, MessageFormat format, String delimiter) {
        return new DefaultSeaTunnelRowSerializer(DefaultSeaTunnelRowSerializer.topicExtractor(topic, rowType, format), DefaultSeaTunnelRowSerializer.partitionExtractor(null), DefaultSeaTunnelRowSerializer.timestampExtractor(), DefaultSeaTunnelRowSerializer.keyExtractor(null, rowType, format, delimiter), DefaultSeaTunnelRowSerializer.valueExtractor(rowType, format, delimiter), DefaultSeaTunnelRowSerializer.headersExtractor());
    }

    public static DefaultSeaTunnelRowSerializer create(String topic, Integer partition, SeaTunnelRowType rowType, MessageFormat format, String delimiter) {
        return new DefaultSeaTunnelRowSerializer(DefaultSeaTunnelRowSerializer.topicExtractor(topic, rowType, format), DefaultSeaTunnelRowSerializer.partitionExtractor(partition), DefaultSeaTunnelRowSerializer.timestampExtractor(), DefaultSeaTunnelRowSerializer.keyExtractor(null, rowType, format, delimiter), DefaultSeaTunnelRowSerializer.valueExtractor(rowType, format, delimiter), DefaultSeaTunnelRowSerializer.headersExtractor());
    }

    public static DefaultSeaTunnelRowSerializer create(String topic, List<String> keyFields, SeaTunnelRowType rowType, MessageFormat format, String delimiter) {
        return new DefaultSeaTunnelRowSerializer(DefaultSeaTunnelRowSerializer.topicExtractor(topic, rowType, format), DefaultSeaTunnelRowSerializer.partitionExtractor(null), DefaultSeaTunnelRowSerializer.timestampExtractor(), DefaultSeaTunnelRowSerializer.keyExtractor(keyFields, rowType, format, delimiter), DefaultSeaTunnelRowSerializer.valueExtractor(rowType, format, delimiter), DefaultSeaTunnelRowSerializer.headersExtractor());
    }

    private static Function<SeaTunnelRow, Integer> partitionExtractor(Integer partition) {
        return row -> partition;
    }

    private static Function<SeaTunnelRow, Long> timestampExtractor() {
        return row -> null;
    }

    private static Function<SeaTunnelRow, Iterable<Header>> headersExtractor() {
        return row -> null;
    }

    private static Function<SeaTunnelRow, String> topicExtractor(String topic, SeaTunnelRowType rowType, MessageFormat format) {
        if (MessageFormat.COMPATIBLE_DEBEZIUM_JSON.equals((Object)format)) {
            int topicFieldIndex = rowType.indexOf("topic");
            return row -> row.getField(topicFieldIndex).toString();
        }
        String regex = "\\$\\{(.*?)\\}";
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher matcher = pattern.matcher(topic);
        boolean isExtractTopic = matcher.find();
        if (!isExtractTopic) {
            return row -> topic;
        }
        String topicField = matcher.group(1);
        List<String> fieldNames = Arrays.asList(rowType.getFieldNames());
        if (!fieldNames.contains(topicField)) {
            throw new KafkaConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, String.format("Field name { %s } is not found!", topic));
        }
        int topicFieldIndex = rowType.indexOf(topicField);
        return row -> {
            Object topicFieldValue = row.getField(topicFieldIndex);
            if (topicFieldValue == null) {
                throw new KafkaConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, "The column value is empty!");
            }
            return topicFieldValue.toString();
        };
    }

    private static Function<SeaTunnelRow, byte[]> keyExtractor(List<String> keyFields, SeaTunnelRowType rowType, MessageFormat format, String delimiter) {
        if (MessageFormat.COMPATIBLE_DEBEZIUM_JSON.equals((Object)format)) {
            CompatibleDebeziumJsonSerializationSchema serializationSchema = new CompatibleDebeziumJsonSerializationSchema(rowType, true);
            return row -> serializationSchema.serialize((SeaTunnelRow)row);
        }
        if (keyFields == null || keyFields.isEmpty()) {
            return row -> null;
        }
        SeaTunnelRowType keyType = DefaultSeaTunnelRowSerializer.createKeyType(keyFields, rowType);
        Function<SeaTunnelRow, SeaTunnelRow> keyRowExtractor = DefaultSeaTunnelRowSerializer.createKeyRowExtractor(keyType, rowType);
        SerializationSchema serializationSchema = DefaultSeaTunnelRowSerializer.createSerializationSchema(keyType, format, delimiter, true);
        return row -> serializationSchema.serialize((SeaTunnelRow)keyRowExtractor.apply((SeaTunnelRow)row));
    }

    private static Function<SeaTunnelRow, byte[]> valueExtractor(SeaTunnelRowType rowType, MessageFormat format, String delimiter) {
        SerializationSchema serializationSchema = DefaultSeaTunnelRowSerializer.createSerializationSchema(rowType, format, delimiter, false);
        return row -> serializationSchema.serialize(row);
    }

    private static SeaTunnelRowType createKeyType(List<String> keyFieldNames, SeaTunnelRowType rowType) {
        int[] keyFieldIndexArr = new int[keyFieldNames.size()];
        SeaTunnelDataType[] keyFieldDataTypeArr = new SeaTunnelDataType[keyFieldNames.size()];
        for (int i = 0; i < keyFieldNames.size(); ++i) {
            int rowFieldIndex;
            String keyFieldName = keyFieldNames.get(i);
            keyFieldIndexArr[i] = rowFieldIndex = rowType.indexOf(keyFieldName);
            keyFieldDataTypeArr[i] = rowType.getFieldType(rowFieldIndex);
        }
        return new SeaTunnelRowType(keyFieldNames.toArray(new String[0]), keyFieldDataTypeArr);
    }

    private static Function<SeaTunnelRow, SeaTunnelRow> createKeyRowExtractor(SeaTunnelRowType keyType, SeaTunnelRowType rowType) {
        int[] keyIndex = new int[keyType.getTotalFields()];
        for (int i = 0; i < keyType.getTotalFields(); ++i) {
            keyIndex[i] = rowType.indexOf(keyType.getFieldName(i));
        }
        return row -> {
            Object[] fields = new Object[keyType.getTotalFields()];
            for (int i = 0; i < keyIndex.length; ++i) {
                fields[i] = row.getField(keyIndex[i]);
            }
            return new SeaTunnelRow(fields);
        };
    }

    private static SerializationSchema createSerializationSchema(SeaTunnelRowType rowType, MessageFormat format, String delimiter, boolean isKey) {
        switch (format) {
            case JSON: {
                return new JsonSerializationSchema(rowType);
            }
            case TEXT: {
                return TextSerializationSchema.builder().seaTunnelRowType(rowType).delimiter(delimiter).build();
            }
            case CANAL_JSON: {
                return new CanalJsonSerializationSchema(rowType);
            }
            case DEBEZIUM_JSON: {
                return new DebeziumJsonSerializationSchema(rowType);
            }
            case COMPATIBLE_DEBEZIUM_JSON: {
                return new CompatibleDebeziumJsonSerializationSchema(rowType, isKey);
            }
        }
        throw new SeaTunnelJsonFormatException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "Unsupported format: " + (Object)((Object)format));
    }

    public DefaultSeaTunnelRowSerializer(Function<SeaTunnelRow, String> topicExtractor, Function<SeaTunnelRow, Integer> partitionExtractor, Function<SeaTunnelRow, Long> timestampExtractor, Function<SeaTunnelRow, byte[]> keyExtractor, Function<SeaTunnelRow, byte[]> valueExtractor, Function<SeaTunnelRow, Iterable<Header>> headersExtractor) {
        this.topicExtractor = topicExtractor;
        this.partitionExtractor = partitionExtractor;
        this.timestampExtractor = timestampExtractor;
        this.keyExtractor = keyExtractor;
        this.valueExtractor = valueExtractor;
        this.headersExtractor = headersExtractor;
    }
}

