/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.utils;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveJdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(HiveJdbcUtils.class);

    public static synchronized void doKerberosAuthentication(JdbcConnectionConfig jdbcConfig) {
        String principal = jdbcConfig.kerberosPrincipal;
        String keytabPath = jdbcConfig.kerberosKeytabPath;
        String krb5Path = jdbcConfig.krb5Path;
        System.setProperty("java.security.krb5.conf", krb5Path);
        Configuration configuration = new Configuration();
        if (StringUtils.isBlank((CharSequence)principal) || StringUtils.isBlank((CharSequence)keytabPath)) {
            log.warn("Principal [{}] or keytabPath [{}] is empty, it will skip kerberos authentication", (Object)principal, (Object)keytabPath);
        } else {
            configuration.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)configuration);
            try {
                log.info("Start Kerberos authentication using principal {} and keytab {}", (Object)principal, (Object)keytabPath);
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabPath);
                log.info("Kerberos authentication successful");
            }
            catch (IOException e) {
                String errorMsg = String.format("Kerberos authentication failed using this principal [%s] and keytab path [%s]", principal, keytabPath);
                throw new JdbcConnectorException(JdbcConnectorErrorCode.KERBEROS_AUTHENTICATION_FAILED, errorMsg, e);
            }
        }
    }
}

