/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.source;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.DynamicChunkSplitter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.FixedChunkSplitter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChunkSplitter
implements AutoCloseable,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(ChunkSplitter.class);
    protected JdbcSourceConfig config;
    protected final JdbcConnectionProvider connectionProvider;
    protected final JdbcDialect jdbcDialect;
    private final int fetchSize;
    private final boolean autoCommit;

    public ChunkSplitter(JdbcSourceConfig config) {
        this.config = config;
        this.autoCommit = config.getJdbcConnectionConfig().isAutoCommit();
        this.fetchSize = config.getFetchSize();
        this.jdbcDialect = JdbcDialectLoader.load(config.getJdbcConnectionConfig().getUrl(), config.getCompatibleMode());
        this.connectionProvider = this.jdbcDialect.getJdbcConnectionProvider(config.getJdbcConnectionConfig());
    }

    public static ChunkSplitter create(JdbcSourceConfig config) {
        log.info("Switch to {} chunk splitter", (Object)(config.isUseDynamicSplitter() ? "dynamic" : "fixed"));
        return config.isUseDynamicSplitter() ? new DynamicChunkSplitter(config) : new FixedChunkSplitter(config);
    }

    @Override
    public synchronized void close() {
        if (this.connectionProvider != null) {
            this.connectionProvider.closeConnection();
        }
    }

    public Collection<JdbcSourceSplit> generateSplits(JdbcSourceTable table) throws Exception {
        Collection<JdbcSourceSplit> splits;
        log.info("Start splitting table {} into chunks...", (Object)table.getTablePath());
        long start = System.currentTimeMillis();
        Optional<SeaTunnelRowType> splitKeyOptional = this.findSplitKey(table);
        if (!splitKeyOptional.isPresent()) {
            JdbcSourceSplit split = this.createSingleSplit(table);
            splits = Collections.singletonList(split);
        } else {
            if (splitKeyOptional.get().getTotalFields() != 1) {
                throw new UnsupportedOperationException("Currently, only support one split key");
            }
            splits = this.createSplits(table, splitKeyOptional.get());
        }
        long end = System.currentTimeMillis();
        log.info("Split table {} into {} chunks, time cost: {}ms.", new Object[]{table.getTablePath(), splits.size(), end - start});
        return splits;
    }

    protected abstract Collection<JdbcSourceSplit> createSplits(JdbcSourceTable var1, SeaTunnelRowType var2) throws SQLException, Exception;

    public PreparedStatement generateSplitStatement(JdbcSourceSplit split, TableSchema schema) throws SQLException {
        if (split.getSplitKeyName() == null) {
            return this.createSingleSplitStatement(split);
        }
        return this.createSplitStatement(split, schema);
    }

    protected abstract PreparedStatement createSplitStatement(JdbcSourceSplit var1, TableSchema var2) throws SQLException;

    protected PreparedStatement createPreparedStatement(String sql) throws SQLException {
        Connection connection = this.getOrEstablishConnection();
        if (connection.getAutoCommit() != this.autoCommit) {
            connection.setAutoCommit(this.autoCommit);
        }
        if (StringUtils.isNotBlank((CharSequence)this.config.getWhereConditionClause())) {
            sql = String.format("SELECT * FROM (%s) tmp %s", sql, this.config.getWhereConditionClause());
        }
        log.debug("Prepared statement: {}", (Object)sql);
        return this.jdbcDialect.creatPreparedStatement(connection, sql, this.fetchSize);
    }

    protected Connection getOrEstablishConnection() throws SQLException {
        try {
            return this.connectionProvider.getOrEstablishConnection();
        }
        catch (ClassNotFoundException e) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.CLASS_NOT_FOUND, "JDBC-Class not found. - " + e.getMessage(), e);
        }
    }

    protected JdbcSourceSplit createSingleSplit(JdbcSourceTable table) {
        return new JdbcSourceSplit(table.getTablePath(), this.createSplitId(table.getTablePath(), 0), table.getQuery(), null, null, null, null);
    }

    protected PreparedStatement createSingleSplitStatement(JdbcSourceSplit split) throws SQLException {
        String splitQuery = split.getSplitQuery();
        if (StringUtils.isEmpty((CharSequence)splitQuery)) {
            splitQuery = String.format("SELECT * FROM %s", this.jdbcDialect.tableIdentifier(split.getTablePath()));
        }
        return this.createPreparedStatement(splitQuery);
    }

    protected Object queryMin(JdbcSourceTable table, String columnName, Object excludedLowerBound) throws SQLException {
        Map<String, Column> columns = table.getCatalogTable().getTableSchema().getColumns().stream().collect(Collectors.toMap(c -> c.getName(), c -> c));
        Column column = columns.get(columnName);
        columnName = this.jdbcDialect.quoteIdentifier(columnName);
        columnName = this.jdbcDialect.convertType(columnName, column.getSourceType());
        String minQuery = StringUtils.isNotBlank((CharSequence)table.getQuery()) ? String.format("SELECT MIN(%s) FROM (%s) tmp WHERE %s > ?", columnName, table.getQuery(), columnName) : String.format("SELECT MIN(%s) FROM %s WHERE %s > ?", columnName, this.jdbcDialect.tableIdentifier(table.getTablePath()), columnName);
        try (PreparedStatement ps = this.getOrEstablishConnection().prepareStatement(minQuery);){
            ps.setObject(1, excludedLowerBound);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    Object object = rs.getObject(1);
                    return object;
                }
                throw new SQLException(String.format("No result returned after running query [%s]", minQuery));
            }
        }
    }

    protected Pair<Object, Object> queryMinMax(JdbcSourceTable table, String columnName) throws SQLException {
        Map<String, Column> columns = table.getCatalogTable().getTableSchema().getColumns().stream().collect(Collectors.toMap(c -> c.getName(), c -> c));
        Column column = columns.get(columnName);
        columnName = this.jdbcDialect.quoteIdentifier(columnName);
        columnName = this.jdbcDialect.convertType(columnName, column.getSourceType());
        String sqlQuery = StringUtils.isNotBlank((CharSequence)table.getQuery()) ? String.format("SELECT MIN(%s), MAX(%s) FROM (%s) tmp", columnName, columnName, table.getQuery()) : String.format("SELECT MIN(%s), MAX(%s) FROM %s", columnName, columnName, this.jdbcDialect.tableIdentifier(table.getTablePath()));
        try (Statement stmt = this.getOrEstablishConnection().createStatement();){
            Pair pair;
            block16: {
                ResultSet resultSet;
                block14: {
                    Pair pair2;
                    block15: {
                        log.info("Split table, query min max: {}", (Object)sqlQuery);
                        resultSet = stmt.executeQuery(sqlQuery);
                        try {
                            if (!resultSet.next()) break block14;
                            Object min = resultSet.getObject(1);
                            Object max = resultSet.getObject(2);
                            pair2 = Pair.of((Object)min, (Object)max);
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return pair2;
                }
                pair = Pair.of(null, null);
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return pair;
        }
    }

    protected Optional<SeaTunnelRowType> findSplitKey(JdbcSourceTable table) {
        List uniqueKeys;
        List constraintKeys;
        TableSchema schema = table.getCatalogTable().getTableSchema();
        List columns = schema.getColumns();
        Map<String, Column> columnMap = columns.stream().collect(Collectors.toMap(Column::getName, column -> column, (c1, c2) -> c1));
        if (table.getPartitionColumn() != null) {
            String partitionColumn = table.getPartitionColumn();
            Column column2 = columnMap.get(partitionColumn);
            if (column2 == null) {
                throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, String.format("Partitioned column(%s) don't exist in the table columns", partitionColumn));
            }
            if (!this.isSupportSplitColumn(column2)) {
                throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, String.format("%s is not numeric/string type", partitionColumn));
            }
            return Optional.of(new SeaTunnelRowType(new String[]{partitionColumn}, new SeaTunnelDataType[]{column2.getDataType()}));
        }
        PrimaryKey pk = schema.getPrimaryKey();
        if (pk != null) {
            for (String pkField : pk.getColumnNames()) {
                Column column3 = columnMap.get(pkField);
                if (!this.isSupportSplitColumn(column3)) continue;
                return Optional.of(new SeaTunnelRowType(new String[]{pkField}, new SeaTunnelDataType[]{column3.getDataType()}));
            }
        }
        if ((constraintKeys = schema.getConstraintKeys()) != null && !(uniqueKeys = constraintKeys.stream().filter(constraintKey -> constraintKey.getConstraintType() == ConstraintKey.ConstraintType.UNIQUE_KEY).collect(Collectors.toList())).isEmpty()) {
            for (ConstraintKey uniqueKey : uniqueKeys) {
                for (ConstraintKey.ConstraintKeyColumn uniqueKeyColumn : uniqueKey.getColumnNames()) {
                    String uniqueKeyColumnName = uniqueKeyColumn.getColumnName();
                    Column column4 = columnMap.get(uniqueKeyColumnName);
                    if (!this.isSupportSplitColumn(column4)) continue;
                    return Optional.of(new SeaTunnelRowType(new String[]{uniqueKeyColumnName}, new SeaTunnelDataType[]{column4.getDataType()}));
                }
            }
        }
        log.warn("No split key found for table {}", (Object)table.getTablePath());
        return Optional.empty();
    }

    protected boolean isSupportSplitColumn(Column splitColumn) {
        SeaTunnelDataType dataType = splitColumn.getDataType();
        switch (dataType.getSqlType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case STRING: 
            case DATE: {
                return true;
            }
        }
        return false;
    }

    protected String createSplitId(TablePath tablePath, int index) {
        return String.format("%s-%s", tablePath, index);
    }
}

